require("debug.lua");
if (DEBUG_FUNCTION)
then
	require("101_common_oop.lua");
	require("111_logger.lua");
	require("151_common_environment.lua");
	require("152_global_instance.lua");
end
----------------------------------------------------------------------------------------------------------
-- 
-- XbhNENX
-- 
-- yield()R}hɈˑȂ`ŃXbh̓s܂B
-- s鏈[vĂƂ܂łĂAĂ܂B
-- Ȃ̂ňꎞIȏÛ߃Xbh𗘗pꍇɌĂ܂B
--
--	˂ǂ{̃XbhgĂȂ͗lB
--	@VOXbĥ悤ȋĈňӖȂȂB
--	@create_thread()Ɉ悤ɂȂ邱Ƃ҂ācHB
--
--	o
--		\bh`́u:vŒ`Function
--		ÖٕϐuselfvɂƂB
--
--		coroutine.yield()  yield()͕ʕB
--
--		̃Xbh LuaW coroutine łĂB
--
--		ǂ̌Ăяo wait() or yield() Ă
--		AĂȂȂ̂Ŋ{ZɂƂǂ߂ׂB
--		iwaitȂǂ̓coroutine.yield()ĂȂBj
--
--		Ȃ coroutine.yield() Ȃقc킩
--
--
----------------------------------------------------------------------------------------------------------
SynchronizableThreadExecutor=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	-- RXgN^
	--	
	--		name			: CX^X̖O
	----------------------------------------------------------------------------------------------------------
	function SynchronizableThreadExecutor:constructor(name)

		self.name=name;				-- CX^X̖O
		self.executeTargets={};		-- sEΏۃCX^X
		self.executeThreads={};		-- sEΏۂ̃Xbh

	end

	----------------------------------------------------------------------------------------------------------
	-- ǉo^܂B
	--	
	--		executeTarget	: sΏۃNXCX^X
	--						  sΏۃNXCX^X͈ȉ̃\bhĂKv܂B
	--							call() 			B
	--						  ꉞAL\bhbp[NXSynchronizableThread 
	--						  pӂĂ̂ŁA𗘗p邱Ƃ߂܂B
	----------------------------------------------------------------------------------------------------------
	function SynchronizableThreadExecutor:add(executeTarget)
		table.insert(self.executeTargets, executeTarget);
	end

	----------------------------------------------------------------------------------------------------------
	-- o^ꂽʃXbhŎs܂B
	-- SXbh̏I҂ꍇ́A{\bhĂяoɕK
	-- awaitTermination()ĂяoĂB
	----------------------------------------------------------------------------------------------------------
	function SynchronizableThreadExecutor:invokeAll()
		local executeFunction = nil;
		local thread = nil;
		for key, executeTarget in pairs(self.executeTargets)
		do
			-- ̃NXCX^Xucallv\bhƂB
			-- executeTarget:call() ̂ƂC[WB
			executeFunction = executeTarget["call"];

			-- create_threadƈnȂ̂ coroutine ŎOB
			-- coroutine.resumeŃ\bhɁuselfvpnĂB
			thread = coroutine.create(executeFunction);
			table.insert(self.executeThreads, thread);
			coroutine.resume(thread, executeTarget);
			--coroutine.yield();
			--create_thread(executeFunction);
		end
	end

	----------------------------------------------------------------------------------------------------------
	-- ʃXbhŋNꂽ̊҂܂B
	--	
	--		limitFrame		:҂őFrame
	--	߂l
	--		limitFrameȓɑSXbhIꍇtrue, 
	--		IȂꍇfalse
	----------------------------------------------------------------------------------------------------------
	function SynchronizableThreadExecutor:awaitTermination(limitFrame)
		local startTime = battle_time;
		local elapsedTime = 0;
		while (not self:isTerminatedAll())
		do
			if (elapsedTime > limitFrame)
			then
				logger:warn("SynchronizableThreadExecutor", "XbhwԓɏI܂łB");
				break;
			end
			-- oFrame擾 zVˑbattle_timeŌvB
			elapsedTime = battle_time - startTime;
			--coroutine.yield();
			logger:trace("SynchronizableThreadExecutor", "vZ :" .. elapsedTime);
		end
		logger:debug("SynchronizableThreadExecutor", "vZɂ :" .. elapsedTime);
		return self:isTerminatedAll();
	end

	----------------------------------------------------------------------------------------------------------
	-- ʃXbhŋNꂽSďIĂꍇtrue
	----------------------------------------------------------------------------------------------------------
	function SynchronizableThreadExecutor:isTerminatedAll()
		local terminatedAll = true;
		for key, executeThread in pairs(self.executeThreads)
		do
			terminatedAll = terminatedAll and (coroutine.status(executeThread) == "dead");
		end
		return terminatedAll;
	end

----------------------------------------------------------------------------------------------------------
-- 
-- XbhNENXɓo^邽߂̃bp[NX
-- SynchronizableThreadExecutorƍ킹ėpĂB
-- 
----------------------------------------------------------------------------------------------------------
SynchronizableThread=extends(NamedObject);

	----------------------------------------------------------------------------------------------------------
	-- RXgN^
	--	
	--		instance		: NXCX^Xfunction̂
	--		methodName		: NXCX^X̏ꍇAĂяo\bhw
	--		args			: \bh or ֐ɓn, e[u`ŁB
	----------------------------------------------------------------------------------------------------------
	function SynchronizableThread:constructor(instance, methodName, args)
		self.name = "SynchronizableThread : " .. tostring(methodName);
		self.instance = instance;		-- NXCX^X or function
		self.methodName = methodName;	-- sΏۃ\bh
		self.args = args;				-- 
	end

	----------------------------------------------------------------------------------------------------------
	-- RXgN^Ŏw肳ꂽ\bh or ֐Ăяo܂B
	----------------------------------------------------------------------------------------------------------
	function SynchronizableThread:call()
		local executeFunction = self:getExecuteFunction();
		if (self.args ~= nil)
		then
			if (type(self.args) == "table")
			then
				executeFunction(self.instance, unpack(self.args));
			else
				executeFunction(self.instance, self.args);
			end
		else
			executeFunction(self.instance);
		end
		--logger:trace("SynchronizableThread", "vZI:" .. self.methodName);
		--coroutine.yield();
	end

	----------------------------------------------------------------------------------------------------------
	-- ֐ or NXCX^X̃\bh擾܂B
	-- NXCX^X͎tableIuWFNgȂ̂
	-- rawget(table, index)Ń\bh̎̂o܂B
	----------------------------------------------------------------------------------------------------------
	function SynchronizableThread:getExecuteFunction()
		if (type(self.instance) == "table")
		then
			return self.instance[self.methodName];
		elseif (type(self.instance) == "function")
		then
			return self.instance;
		end
		-- słԂȂ̂ŃG[ɂB
		assert(false, "NXCX^Xł֐łȂsł܂B");
	end

----------------------------------------------------------------------------------------------------------
-- eXgp
----------------------------------------------------------------------------------------------------------
function main()
	test_thread();
	while (true)
	do
		yield();
	end
end
function test_thread()

	local testA = TestA.new("A");
	local testC = TestA.new("C");
	local executeThreadA = SynchronizableThread.new(testA, "testPrint", {"aaa", 22});
	local executeThreadB = SynchronizableThread.new(testB);
	local executeThreadC = SynchronizableThread.new(testC, "testPrint", "bbb");

	local executor = SynchronizableThreadExecutor.new("hoge");

	executor:add(executeThreadA);
	executor:add(executeThreadB);
	executor:add(executeThreadC);

	executor:invokeAll();
	print(executor:awaitTermination(1));

end

TestA=extends(NamedObject);

	function TestA:constructor(name)
		self.name=name;
	end

	function TestA:testPrint(str, ex)
		for i=1,5
		do
			print(self.name .. " Test [" .. tostring(str) .. tostring(ex));
		end
	end

function testB()
	for i=1,6
	do
		print("testB[");
	end
end
