require("debug.lua");
if(DEBUG_FUNCTION)
then
	require("101_common_oop.lua");
	require("111_logger.lua");
	require("113_common_collections.lua");
	require("151_common_environment.lua");
	require("152_global_instance.lua");
	require("161_common_functions.lua");
	require("162_round_utils.lua");
	require("201_capture_info.lua");
end

----------------------------------------------------------------------------------------------------------
--
-- wK֌W풓
--
----------------------------------------------------------------------------------------------------------
AbstractLearnDaemon=extends(NamedObject);

	function AbstractLearnDaemon:constructor(name, target, enable, learnSituation, learnCondition)
		self.name = name;						-- wKCX^X
		self.target = target;					-- wKΏ
		self.enable = enable;					-- wK on/off
		self.learnSituation = learnSituation;	-- wK
		self.learnCondition = learnCondition;	-- wK
	end

	function AbstractLearnDaemon:learn()
		while (not battleFinished())
		do
			self.target = learningTarget;
			self.enable = runningLearning;
			if ((self.enable) and (self.learnSituation(self.target)))
			then
				self:process();
			end
			yield();
		end
	end

	function AbstractLearnDaemon:process()
		error("processĂ");
	end

----------------------------------------------------------------------------------------------------------
--
-- swKNX
--
----------------------------------------------------------------------------------------------------------
LearnMotion=extends(AbstractLearnDaemon);

	function LearnMotion:constructor(name, target, enable, learnSituation, learnCondition)
		self.name = name;						-- wKCX^X
		self.target = target;					-- wKΏ
		self.enable = enable;					-- wK on/off
		self.learnSituation = learnSituation;	-- wK
		self.learnCondition = learnCondition;	-- wK
		self.learnTable = learnTableManager:getLearnTable(self.name);	-- wKe[u(LearnTableCX^X 301_learn_table.lua)
		self.beforeLearnedCaptureInfo = nil;
	end

	function LearnMotion:process()

		-- tracedCurrent͂OŁEEEB
		-- from 201_motion_tracer.lua
		local captureInfo = tracer[self.target]:tracedCurrent();
		if (captureInfo == nil)
		then
			return;
		end
		--print(self.name, self.target, tracer[self.target]:tracedCurrent():serialize());

		--[[
		if (captureInfo.frame < LEARNING_FRAME_BORDER)
		then
			return;
		end
		]]--

		if (captureInfo:equals(self.beforeLearnedCaptureInfo))
		then
			return;
		end

		if (not self.learnCondition(self.target))
		then
			return;
		end

		self.learnTable:add(captureInfo);
		self.beforeLearnedCaptureInfo = captureInfo;
		logger:debug(self.name, " wKΏ:" .. self.target ..
								" wKL:" .. captureInfo:getParameter(CaptureInfo_my_char) .. 
								" wKs:" .. captureInfo.act);
	end


----------------------------------------------------------------------------------------------------------
--
-- sAwKNX
--
----------------------------------------------------------------------------------------------------------
LearnRelation=extends(AbstractLearnDaemon);

	function LearnRelation:constructor(name, target, enable, learnSituation, learnCondition)
		self.name = name;						-- wKCX^X
		self.target = target;					-- wKΏ
		self.enable = enable;					-- wK on/off
		self.learnSituation = learnSituation;	-- wK
		self.learnCondition = learnCondition;	-- wK
		self.relationTable = learnTableManager:getRelationTable(self.name);
		self.beforeLearnedCaptureInfo = nil;
	end

	function LearnRelation:process()

		-- from 201_motion_tracer.lua
		local captureInfo = tracer[self.target]:tracedCurrent();
		local beforeTracedCaptureInfo = tracer[self.target]:tracedBefore();
		local beforeTracedCaptureInfoBefore = tracer[self.target]:history(3)

		if (captureInfo == nil)
		then
			return;
		end

		--[[
		if (captureInfo.frame < LEARNING_FRAME_BORDER)
		then
			return;
		end
		]]--

		if (captureInfo:equals(self.beforeLearnedCaptureInfo))
		then
			return;
		end

		if (captureInfo.act == 0)
		then
			return;
		end
		
		if (not self.learnCondition(self.target))
		then
			return;
		end

		--[[
		print(beforeTracedCaptureInfo, captureInfo, captureInfo.act);
		]]--
		-- ǂpȂ̂łB˂悭Ȃ
		if (not isRelativeMotion(captureInfo.act))
		then
			return;
		end

		if (beforeTracedCaptureInfo == nil)
		then
			-- _Ƃ݂Ȃ
			self:registMotionRelation(self.relationTable, MotionRelation.new(captureInfo.act));
		elseif (beforeTracedCaptureInfo.act == 0)
		then
			-- _Ƃ݂Ȃ
			self:registMotionRelation(self.relationTable, MotionRelation.new(captureInfo.act));
		elseif (not self.relationTable:hasNextMotion(beforeTracedCaptureInfo.act))
		then
			-- {sA̗vfł͂ȂA_1ƂȂ肤邽ߕpx͋0B
			-- ܂ōsÃL[Ƃēo^BႦΗˍUƂB
			self.relationTable:addNextMotion(MotionRelation.new(beforeTracedCaptureInfo.act));
			self.relationTable.frequency[beforeTracedCaptureInfo.act] = 0;
			self:registMotionRelation(self.relationTable:getNextMotion(beforeTracedCaptureInfo.act), MotionRelation.new(captureInfo.act));
		else
			-- self.relationTableɂȂƂB
			print(beforeTracedCaptureInfo.act, captureInfo.act, self.relationTable:hasNextMotion(beforeTracedCaptureInfo.act));
			self:registMotionRelation(self.relationTable:getNextMotion(beforeTracedCaptureInfo.act), MotionRelation.new(captureInfo.act));
			--[[
			if (beforeTracedCaptureInfo.act ~= 2140)
			then
				print(beforeTracedCaptureInfo.act, captureInfo.act, self.relationTable:hasNextMotion(beforeTracedCaptureInfo.act));
				self:registMotionRelation(self.relationTable:getNextMotion(beforeTracedCaptureInfo.act), MotionRelation.new(captureInfo.act));
			else
				print("relation:", captureInfo.act, beforeTracedCaptureInfo.act, beforeTracedCaptureInfoBefore.act);
				-- beforeTracedCaptureInfo2140(ĕ]d)̏ꍇȂOɕKsg[XĂ͂B
				assert(beforeTracedCaptureInfoBefore, "2140̑O nilB܂肦");
				print(beforeTracedCaptureInfoBefore.act, captureInfo.act, self.relationTable:hasNextMotion(beforeTracedCaptureInfoBefore.act));
				self:registMotionRelation(self.relationTable:getNextMotion(beforeTracedCaptureInfoBefore.act), MotionRelation.new(captureInfo.act));
			end
			]]--
		end
		--[[
		if (self.beforeLearnedCaptureInfo == nil)
		then
			-- _Ƃ݂Ȃ
			self:registMotionRelation(self.relationTable, MotionRelation.new(captureInfo.act));
		elseif (self.beforeLearnedCaptureInfo.act == 0)
		then
			-- _Ƃ݂Ȃ
			self:registMotionRelation(self.relationTable, MotionRelation.new(captureInfo.act));
		else
			-- self.relationTableɂȂƂB
			--print(self.beforeLearnedCaptureInfo.act, captureInfo.act, self.relationTable:hasNextMotion(self.beforeLearnedCaptureInfo.act));
			self:registMotionRelation(self.relationTable:getNextMotion(self.beforeLearnedCaptureInfo.act), MotionRelation.new(captureInfo.act));
		end
		]]--
		self.beforeLearnedCaptureInfo = captureInfo;
		logger:debug(self.name, " wKΏ:" .. self.target ..
								" wKL:" .. captureInfo:getParameter(CaptureInfo_my_char) .. 
								" wKs:" .. captureInfo.act);

	end

	function LearnRelation:registMotionRelation(targetMotionRelation, addMotionRelation)
		targetMotionRelation:addNextMotion(addMotionRelation);

		-- ŏ̈񂾂 root ɕۑBfrequency = 0 ͋B
		if (not self.relationTable:hasNextMotion(addMotionRelation.act))
		then
			self.relationTable:addNextMotion(addMotionRelation);
			-- [Vl 0 słȂ́AAsł͂Ȃ͕̂px0B
			if (not isRootMotion(addMotionRelation.act))
			then
				self.relationTable.frequency[addMotionRelation.act] = 0;
			end
		end
	end
