----------------------------------------------------------------------------------------------------------
-- 
-- wKe[u֘A@\
--
----------------------------------------------------------------------------------------------------------

----------------------------------------------------------------------------------------------------------
-- wKe[u𕜌܂B
--	Ώۃe[u
--		E{swKe[u
--		EUswKe[u
--		EK[hswKe[u
----------------------------------------------------------------------------------------------------------
function deserializeMotionTable()
	deserializeLearnTables();
	deserializeRelations();
end

function deserializeLearnTables()
	deserializeTargetLearnTable(AI_NAME_OFFENSIVE,		AI_OFFENSIVE_FILENAME);
	deserializeTargetLearnTable(AI_NAME_KATAME,			AI_KATAME_FILENAME);
	deserializeTargetLearnTable(AI_NAME_DEFENSIVE,		AI_DEFENSIVE_FILENAME);
	deserializeTargetLearnTable(AI_NAME_OIUCHI,			AI_OIUCHI_FILENAME);
	deserializeTargetLearnTable(AI_NAME_KAIHIKEKKAI,	AI_KAIHIKEKKAI_FILENAME);
	deserializeTargetLearnTable(AI_NAME_RECOVERY,		AI_RECOVERY_FILENAME);
	deserializeTargetLearnTable(AI_NAME_GUARD,			AI_GUARD_FILENAME);
	deserializeTargetLearnTable(AI_NAME_GUREIZU,		AI_GUREIZU_FILENAME);
end

function deserializeRelations()
	deserializeTargetRelationTable(AI_NAME_OFFENSIVE,	RELATION_OFFENSIVE_FILENAME);
	deserializeTargetRelationTable(AI_NAME_KATAME,		RELATION_KATAME_FILENAME);
	deserializeTargetRelationTable(AI_NAME_DEFENSIVE,	RELATION_DEFENSIVE_FILENAME);
	deserializeTargetRelationTable(AI_NAME_OIUCHI,		RELATION_OIUCHI_FILENAME);
	deserializeTargetRelationTable(AI_NAME_KAIHIKEKKAI,	RELATION_KAIHIKEKKAI_FILENAME);
	deserializeTargetRelationTable(AI_NAME_RECOVERY,	RELATION_RECOVERY_FILENAME);
end

function deserializeTargetLearnTable(name, fileName)
	local learnTable = learnTableManager:getLearnTable(name);
	if (learnTable == nil)
	then
		return;
	end
	local reader = InputStreamReader.new(fileName);
	deserializeCaptureInfo(reader, learnTable);
end

----------------------------------------------------------------------------------------------------------
-- eswKe[uCaptureInfosPʂŕ܂B
-- 邢̂ł΂B
----------------------------------------------------------------------------------------------------------
function deserializeCaptureInfo(reader, learnTable)
	local captureInfo = nil;
	local readLine = reader:readNextLine();
	while (readLine ~= nil)
	do
		captureInfo = CaptureInfo.new();
		captureInfo:deserialize(readLine);
		learnTable:add(captureInfo);
		readLine = reader:readNextLine();
	end
	reader:close();
end

----------------------------------------------------------------------------------------------------------
-- sAwKe[u𕜌܂B
-- 邢̂ł΂B
-- ȂKB
-- TODO rootɑ݂ȂMotion̕
----------------------------------------------------------------------------------------------------------
function deserializeTargetRelationTable(name, fileName)
	local rootRelation = learnTableManager:getRelationTable(name);
	if (rootRelation == nil)
	then
		return;
	end

	local reader = InputStreamReader.new(fileName);
	local readLine = reader:readNextLine();

	local tempStr = nil;
	local currentAct = 0;
	local relation = nil;

	while (readLine ~= nil)
	do
		tempStr, separator = string.match(readLine, "([^,]*)(,?)");
		currentAct = tonumber(tempStr);
		if (currentAct == 0)
		then
			rootRelation:deserialize(readLine);
		else
			if (rootRelation:hasNextMotion(currentAct))
			then
				relation = rootRelation:getNextMotion(currentAct);
				relation:deserialize(readLine);
			else
				relation = MotionRelation.new(currentAct);
				relation:deserialize(readLine);
				rootRelation:setNextMotion(relation);
			end
		end
		readLine = reader:readNextLine();
	end
	reader:close();
	
	for act, nextRelation in pairs(rootRelation.nextMotions)
	do
		for nextAct, nextFrequency in pairs(nextRelation.frequency)
		do
			if (rootRelation:hasNextMotion(nextAct))
			then
				nextRelation:setNextMotion(rootRelation:getNextMotion(nextAct));
			else
				-- TODO
			end
		end
	end
end

