#include "pch.hpp"
#include "SortListView.hpp"
#include "ScoreLineDlg.hpp"
#include "ScoreLine.hpp"
#include "Formatter.hpp"
#include "Characters.hpp"
#include "Memento.hpp"
#include "Clipboard.hpp"
#include "SWRSAddrDef.h"
#include "resource.h"

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalPath.hpp"

#define MINIMAL_USE_PROCESSHEAPARRAY
#include "MinimalArray.hpp"

#define EVEN_COLOR 0xFFFFFF
#define ODD_COLOR  0xD0DCD0

#define UC_REFLESH 0xDEAD
#define UC_UNDOSCR 0xBEEF
#define UC_REDOSCR 0xBEAF

#define UC_CLIPBRD 0xFF00

#define PROP_FILTER _T("SCORELINE.FILTER")
#define PROP_P1ID   _T("SCORELINE.P1ID")

static const SLVCOLUMN s_listColumns[] = {
	{ LVCFMT_LEFT,   80, _T("O"),   SLVSORT_LPARAM },
	{ LVCFMT_RIGHT,  55, _T("ΐ퐔"), SLVSORT_INTEGER },
	{ LVCFMT_RIGHT,  55, _T(""),     SLVSORT_INTEGER },
	{ LVCFMT_RIGHT,  55, _T(""),     SLVSORT_INTEGER },
	{ LVCFMT_RIGHT,  55, _T(""),   SLVSORT_INTEGER },
	{ LVCFMT_RIGHT,  55, _T("ߋ30"), SLVSORT_INTEGEREX }
};

__inline
static void ScoreLineQIBSpecDialog_RefleshUnit(HWND listWnd, int i, int win, int lose)
{
	Minimal::ProcessHeapString itemstr;

	LVITEM item;
	item.mask = LVIF_TEXT;

	int sum = win + lose;
	// ΐ퐔
	itemstr = Formatter(_T("%d"), sum);
	item.iItem = i;
	item.iSubItem = 1;
	item.pszText = static_cast<LPTSTR>(itemstr);
	ListView_SetItem(listWnd, &item);
	// 
	itemstr = Formatter(_T("%d"), win);
	item.iSubItem = 2;
	item.pszText = static_cast<LPTSTR>(itemstr);
	ListView_SetItem(listWnd, &item);
	// 
	itemstr = Formatter(_T("%d"), lose);
	item.iSubItem = 3;
	item.pszText = static_cast<LPTSTR>(itemstr);
	ListView_SetItem(listWnd, &item);
	// 
	itemstr = 
		Formatter(_T("%d%%"), 
			::MulDiv(win, 100, sum ? sum : 1));
	item.iSubItem = 4;
	item.pszText = static_cast<LPTSTR>(itemstr);
	ListView_SetItem(listWnd, &item);
}

static void ScoreLineQIBSpecDialog_Reflesh(HWND hDlg)
{
	ScoreLine_Enter();

	SCORELINE_FILTER_DESC *fltCustom = (SCORELINE_FILTER_DESC *)GetProp(hDlg, PROP_FILTER);
	if(!fltCustom)
		goto exception;

	if(!ScoreLine_QueryTrackRecord(*fltCustom))
		goto exception;

	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);

	// ڂLPARAMID}bv𓮓I
	// GetPropÓIX^C̓\[g㏈ʓ|
	int itemIdMap[SWRSCHAR_MAX];
	LVITEM lvitem;
	lvitem.mask = LVIF_PARAM;
	lvitem.iSubItem = 0;
	for (int i = 0; i < _countof(itemIdMap); ++i) {
		lvitem.iItem = i;
		ListView_GetItem(listWnd, &lvitem);
		itemIdMap[i] = lvitem.lParam;
	}

	int sumWinAll, sumLoseAll;
	sumWinAll = sumLoseAll = 0;
	for(int i = 0; i < SWRSCHAR_MAX; ++i) {
		int sumWin, sumLose;
		sumWin = sumLose = 0;
		for(int j = 0; j < SWRSCHAR_MAX; ++j) {
			sumWin  += ScoreLine_Read(j, itemIdMap[i], 0);
			sumLose += ScoreLine_Read(j, itemIdMap[i], 1);
		}
		sumWinAll  += sumWin;
		sumLoseAll += sumLose;
		ScoreLineQIBSpecDialog_RefleshUnit(listWnd, i, sumWin, sumLose);
	}

	LVITEM item;
	item.mask = LVIF_TEXT;
	item.cchTextMax = 256;

	// ߋ50폟
	{
		Minimal::ProcessHeapString itemstr;

		sumWinAll = sumLoseAll = 0;
		SCORELINE_FILTER_DESC filterDesc = *fltCustom;
		filterDesc.mask |= SCORELINE_FILTER__P2ID | SCORELINE_FILTER__LIMIT;
		filterDesc.limit = 50;
		for(int i = 0; i < SWRSCHAR_MAX; ++i) {
			filterDesc.p2id = itemIdMap[i];
			if(!ScoreLine_QueryTrackRecord(filterDesc))
				goto exception;

			int sumWin, sumLose, sum;
			sumWin = sumLose = 0;
			for(int j = 0; j < SWRSCHAR_MAX; ++j) {
				sumWin  += ScoreLine_Read(j, itemIdMap[i], 0);
				sumLose += ScoreLine_Read(j, itemIdMap[i], 1);
			}
			sum = sumWin + sumLose;
			itemstr = 
				Formatter(_T("(%d%%)"), 
					::MulDiv(sumWin, 100, sum ? sum : 1));
			item.iItem = i;
			item.iSubItem = 5;
			item.pszText = static_cast<LPTSTR>(itemstr);
			ListView_SetItem(listWnd, &item);
		}
	}

	ScoreLine_Leave(false);
	return;

exception:
	ScoreLine_Leave(true);
	MessageBox(hDlg, _T("ѕ\̍XVɎs܂"), NULL, MB_OK | MB_ICONSTOP);
}

static void SysMenu_OnClose(HWND hDlg, int x, int y)
{
	DestroyWindow(hDlg);
}

static void SysMenu_OnReflesh(HWND hDlg, int x, int y)
{
	ScoreLineQIBSpecDialog_Reflesh(hDlg);
}

static void SysMenu_OnUndo(HWND hDlg, int x, int y)
{
	Memento_Undo();
	ScoreLineQIBSpecDialog_Reflesh(hDlg);
	::PostMessage(GetParent(hDlg), UM_UPDATESCORELINE, 0, 0);
}

static void SysMenu_OnRedo(HWND hDlg, int x, int y)
{
	Memento_Redo();
	ScoreLineQIBSpecDialog_Reflesh(hDlg);
	::PostMessage(GetParent(hDlg), UM_UPDATESCORELINE, 0, 0);
}

static void SysMenu_OnCopyClipboard(HWND hDlg, int x, int y)
{
	Minimal::ProcessHeapString result;

	for(int i = 0; i < _countof(s_listColumns); ++i) {
		if(s_listColumns[i].fmt == LVCFMT_LEFT) {
			result += s_listColumns[i].text;
			for(int j = ::lstrlen(s_listColumns[i].text); j < s_listColumns[i].cx / 7; ++j)
				result += _T(" ");
		} else {
			for(int j = ::lstrlen(s_listColumns[i].text); j < s_listColumns[i].cx / 7; ++j)
				result += _T(" ");
			result += s_listColumns[i].text;
		}
	}
	result += _T("\x0D\x0A");

	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	int count = ListView_GetItemCount(listWnd);

	for(int i = 0; i < count; ++i) {
		for(int j = 0; j < _countof(s_listColumns); ++j) {
			TCHAR text[64];
			ListView_GetItemText(listWnd, i, j, text, _countof(text));
			if(s_listColumns[j].fmt == LVCFMT_LEFT) {
				result += text;
				for(int k = ::lstrlen(text); k < s_listColumns[j].cx / 7; ++k)
					result += _T(" ");
			} else {
				for(int k = ::lstrlen(text); k < s_listColumns[j].cx / 7; ++k)
					result += _T(" ");
				result += text;
			}
		}
		result += _T("\x0D\x0A");
	}
	SetClipboardText(result, result.GetSize());
}

static LRESULT ScoreLineView_OnCustomDraw(HWND hwnd, LPNMLVCUSTOMDRAW lpnlvCustomDraw)
{
	switch(lpnlvCustomDraw->nmcd.dwDrawStage) {
	case CDDS_PREPAINT:
		return CDRF_NOTIFYITEMDRAW;
	case CDDS_ITEMPREPAINT:
		if(lpnlvCustomDraw->nmcd.dwItemSpec & 1)
			lpnlvCustomDraw->clrTextBk = EVEN_COLOR;
		else
			lpnlvCustomDraw->clrTextBk = ODD_COLOR;
		return CDRF_NOTIFYSUBITEMDRAW;
	default:
		return CDRF_DODEFAULT;
	}
}

static LRESULT ScoreLineView_OnDoubleClick(HWND hParent, HWND hwnd)
{
	LVHITTESTINFO hti;

	hti.flags = LVHT_ONITEMLABEL;
	::GetCursorPos(&hti.pt);
	::ScreenToClient(hwnd, &hti.pt);
	// qbg
	if(ListView_SubItemHitTest(hwnd, &hti) != -1) {
		// 
		if(hti.iSubItem == 2 || hti.iSubItem == 3) {
			SCORELINE_ITEM item;

			SYSTEMTIME loctime;
			GetLocalTime(&loctime);
			SystemTimeToFileTime(&loctime, (LPFILETIME)&item.timestamp);

			LVITEM lvitem;
			lvitem.mask = LVIF_PARAM;
			lvitem.iItem = hti.iItem; lvitem.iSubItem = 0;
			ListView_GetItem(hwnd, &lvitem);

			item.p1name[0] = 0;
			item.p1id = reinterpret_cast<int>(::GetProp(hParent, PROP_P1ID));
			item.p1win = hti.iSubItem == 2 ? 2 : 0;
			item.p2name[0] = 0;
			item.p2id = lvitem.lParam;
			item.p2win = hti.iSubItem == 3 ? 2 : 0;

			ScoreLine_Enter();
			bool failed = !ScoreLine_Append(&item);
			ScoreLine_Leave(failed);
			if(!failed) {
				Memento_Append(MEMENTO_CMD_APPEND, &item);

				ScoreLineQIBSpecDialog_Reflesh(hParent);
				::PostMessage(GetParent(hParent), UM_UPDATESCORELINE, 0, 0);
			}
		}
	}
	return TRUE;
}

static LRESULT ScoreLineView_OnRDoubleClick(HWND hParent, HWND hwnd)
{
	LVHITTESTINFO hti;

	hti.flags = LVHT_ONITEMLABEL;
	::GetCursorPos(&hti.pt);
	::ScreenToClient(hwnd, &hti.pt);
	// qbg
	if(ListView_SubItemHitTest(hwnd, &hti) != -1) {
		// 
		if(hti.iSubItem == 2 || hti.iSubItem == 3) {
			LVITEM lvitem;
			lvitem.mask = LVIF_PARAM;
			lvitem.iItem = hti.iItem; lvitem.iSubItem = 0;
			ListView_GetItem(hwnd, &lvitem);

			SCORELINE_FILTER_DESC *fltCustom = reinterpret_cast<SCORELINE_FILTER_DESC *>(GetProp(hParent, PROP_FILTER));
			if(!fltCustom) {
				::MessageBox(NULL, _T("т̕ύXɎs܂"), NULL, MB_OK);
				return FALSE;
			}
			SCORELINE_FILTER_DESC filterDesc = *fltCustom;
			filterDesc.mask |= SCORELINE_FILTER__P2ID;
			filterDesc.p2id = lvitem.lParam;
			if (hti.iSubItem == 2) {
				filterDesc.mask |= SCORELINE_FILTER__P1WIN;
				filterDesc.p1win = 2;
			} else {
				filterDesc.mask |= SCORELINE_FILTER__P2WIN;
				filterDesc.p2win = 2;
			}

			SCORELINE_ITEM item;
			if (ScoreLine_QueryTrackRecordTop(filterDesc, item)) {
				ScoreLine_Enter();
				bool failed = !ScoreLine_Remove(item.timestamp);
				ScoreLine_Leave(failed);
				if(!failed) {
					Memento_Append(MEMENTO_CMD_REMOVE, &item);

					ScoreLineQIBSpecDialog_Reflesh(hParent);
					::PostMessage(GetParent(hParent), UM_UPDATESCORELINE, 0, 0);
				}
			}
		}
	}
	return TRUE;
}

static BOOL ScoreLineQIBSpecDialog_InitListView(HWND hDlg)
{
	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	SortListView_Initialize(listWnd, s_listColumns, _countof(s_listColumns));

	LVITEM item;
	item.mask = LVIF_TEXT | LVIF_PARAM;
	item.cchTextMax = 256;
	item.iSubItem = 0;
	for(int i = 0; i < ARRAYSIZE(g_characters); ++i) {
		item.pszText = const_cast<LPTSTR>(g_characters[i].abbr);
		item.iItem  = i;
		item.lParam = i;
		ListView_InsertItem(listWnd, &item);
	}

	return TRUE;
}

static void ScoreLineQIBSpecDialog_InitCaption(HWND hDlg, SCORELINE_FILTER_DESC &fltCustom)
{
	Minimal::ProcessHeapString title;

	title = _T("ڍ - ");
	SYSTEMTIME loctime;
	for(int i = 1; i < SCORELINE_FILTER__MAX; i <<= 1) {
		switch(fltCustom.mask & i) {
			case SCORELINE_FILTER__P1ID:
				title += 
					Formatter(_T("1P(%s) "), 
						g_characters[fltCustom.p1id].abbr);
				break;
			case SCORELINE_FILTER__P2NAME:
				title += 
					Formatter(_T("2P[%s] "), fltCustom.p2name);
				break;
			case SCORELINE_FILTER__TIMESTAMP_BEGIN:
				::FileTimeToSystemTime(
					(LPFILETIME)&fltCustom.t_begin, &loctime);
				title += 
					Formatter(_T("%d/%02d/%02d"), 
						loctime.wYear, loctime.wMonth, loctime.wDay);
				break;
			case SCORELINE_FILTER__TIMESTAMP_END:
				::FileTimeToSystemTime(
					(LPFILETIME)&fltCustom.t_end, &loctime);
				title += 
					Formatter(_T("%d/%02d/%02d܂"), 
						loctime.wYear, loctime.wMonth, loctime.wDay);
				break;
		}
	}
	::SetWindowText(hDlg, title);
}

static void ScoreLineQIBSpecDialog_InitSysMenu(HWND hDlg, HMENU hSysMenu)
{
	int itemIndex = 0;
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_REFLESH, _T("ŐV̏ɍXV"));
	::InsertMenu(hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_UNDOSCR, _T("ɖ߂"));
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_REDOSCR, _T("蒼"));
	::InsertMenu(hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_CLIPBRD, _T("Nbv{[hɑ"));
	::InsertMenu(hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
}


static BOOL ScoreLineQIBSpecDialog_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
	SCORELINE_FILTER_DESC *fltCustom = (SCORELINE_FILTER_DESC *)lParam;

	if (fltCustom->mask & SCORELINE_FILTER__P1ID) {
		::SetProp(hDlg, PROP_P1ID, (HANDLE)fltCustom->p1id);
	}
	SetProp(hDlg, PROP_FILTER, (HANDLE)lParam);

	HMENU hSysMenu = ::GetSystemMenu(hDlg, FALSE);
	if(hSysMenu == NULL) return FALSE;


	ScoreLineQIBSpecDialog_InitCaption(hDlg, *fltCustom);
	ScoreLineQIBSpecDialog_InitSysMenu(hDlg, hSysMenu);
	ScoreLineQIBSpecDialog_InitListView(hDlg);
	ScoreLineQIBSpecDialog_Reflesh(hDlg);
	return TRUE;
}


static void ScoreLineQIBSpecDialog_OnCommand(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
{
}

static void ScoreLineQIBSpecDialog_OnSysCommand(HWND hDlg, UINT nID, int x, int y)
{
	if(nID == SC_CLOSE) {
		SysMenu_OnClose(hDlg, x, y);
	} else if(nID == UC_REFLESH) {
		SysMenu_OnReflesh(hDlg, x, y);
	} else if(nID == UC_UNDOSCR) {
		SysMenu_OnUndo(hDlg, x, y);
	} else if(nID == UC_REDOSCR) {
		SysMenu_OnRedo(hDlg, x, y);
	} else if(nID == UC_CLIPBRD) {
		SysMenu_OnCopyClipboard(hDlg, x, y);
	}
}

static LRESULT ScoreLineQIBSpecDialog_OnNotify(HWND hDlg, int idCtrl, LPNMHDR pNMHdr)
{
	switch(idCtrl) {
	case IDC_LIST_SCORELINE:
		switch(pNMHdr->code) {
		case NM_CUSTOMDRAW:
			return ScoreLineView_OnCustomDraw(pNMHdr->hwndFrom, (LPNMLVCUSTOMDRAW)pNMHdr);
		case NM_DBLCLK:
			return ScoreLineView_OnDoubleClick(hDlg, pNMHdr->hwndFrom);
		case NM_RDBLCLK:
			return ScoreLineView_OnRDoubleClick(hDlg, pNMHdr->hwndFrom);
		case LVN_COLUMNCLICK:
			return SortListView_OnColumnClick(hDlg, reinterpret_cast<LPNMLISTVIEW>(pNMHdr));
		}
		break;
	}
	return FALSE;
}

static void ScoreLineQIBSpecDialog_OnDestroy(HWND hDlg)
{
	delete reinterpret_cast<SCORELINE_FILTER_DESC *>(GetProp(hDlg, PROP_FILTER));
	::RemoveProp(hDlg, PROP_FILTER);
}

static void ScoreLineQIBSpecDialog_OnNCRButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT codeHitTest)
{
	if(codeHitTest == HTCAPTION) {
		HMENU hSysMenu = GetSystemMenu(hwnd, FALSE);
		EnableMenuItem(hSysMenu, UC_UNDOSCR, Memento_Undoable() ? MF_ENABLED : MF_GRAYED);
		EnableMenuItem(hSysMenu, UC_REDOSCR, Memento_Redoable() ? MF_ENABLED : MF_GRAYED);
	}
}

BOOL CALLBACK ScoreLineQIBSpecDialog_DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_DLG_MSG(hDlg, WM_INITDIALOG, ScoreLineQIBSpecDialog_OnInitDialog);
	HANDLE_DLG_MSG(hDlg, WM_DESTROY, ScoreLineQIBSpecDialog_OnDestroy);
	HANDLE_DLG_MSG(hDlg, WM_COMMAND, ScoreLineQIBSpecDialog_OnCommand);
	HANDLE_DLG_MSG(hDlg, WM_SYSCOMMAND, ScoreLineQIBSpecDialog_OnSysCommand);
	HANDLE_DLG_MSG(hDlg, WM_NCRBUTTONDOWN, ScoreLineQIBSpecDialog_OnNCRButtonDown);
	HANDLE_DLG_MSG(hDlg, WM_NOTIFY, ScoreLineQIBSpecDialog_OnNotify);
	}
	return FALSE;
}
