#include "pch.hpp"
#include "mainwnd.hpp"
#include "AlwaysRecordable.hpp"
#include "scoreline.hpp"
#include "scorelinedlg.hpp"
#include "shortcutdlg.hpp"
#include "shortcut.hpp"
#include "Formatter.hpp"
#include "TextFileWriter.hpp"
#include "memento.hpp"
#include "clipboard.hpp"
#include "characters.hpp"
#include "SWRSAddrDef.h"
#include "resource.h"

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalPath.hpp"

#define MINIMAL_USE_PROCESSHEAPARRAY
#include "MinimalArray.hpp"

#ifdef USE_AUTORUN
#include "autorun.hpp"
#endif

#define UM_NOTIFYICON (WM_APP + 1)
#define UM_SWRSCALLBACK (WM_APP + 10)

enum INFOTRANSTYPE {
	INFOTRANS_NONE,
	INFOTRANS_PROFILE,
	INFOTRANS_ALL,
	INFOTRANS_MAX = INFOTRANS_ALL
};

static UINT s_WM_TASKBAR_CREATED;
static NOTIFYICONDATA s_nid;
static HMENU s_hPopupMenu;
static HWND  s_hScoreLineDlg;
static BOOL  s_disableSWRSCallback;
static BOOL  s_tcgLimit;
static int   s_tcgCount;
static int   s_tcgAddr;
static INFOTRANSTYPE s_infoTransfer;

static void SWRS_OnKO()
{
	/* ϐ͂f */
	int comm = SWRSGetParam(SWRSPARAM_COMMMODE);
	if(comm == SWRSCOMMMODE_WATCH) return;

	/* A탊~b^ */
	if(s_tcgLimit) {
		// AhX`FL
		int newAddr;
		switch(SWRSGetParam(SWRSPARAM_COMMMODE)) {
		case SWRSCOMMMODE_CLIENT:
			newAddr = SWRSGetParam(SWRSPARAM_TOADDR_CLIENT);
			break;
		case SWRSCOMMMODE_SERVER:
			newAddr = SWRSGetParam(SWRSPARAM_TOADDR_SERVER);
			break;
		default:
			newAddr = s_tcgAddr + 1;
		}
		// AhXςĂXV
		if(newAddr != s_tcgAddr) {
			s_tcgAddr = newAddr;
			s_tcgLimit = 0;
		}
		// SAȏ͂悤Ȃ
		if(++s_tcgLimit > 3)
			return;
	}

	/* ǂݎ */
	int ret;
	char lprof[0x21], rprof[0x21];
	char *plprof = lprof, *prprof = rprof;
	if((ret = SWRSGetParam(SWRSPARAM_LPROFNAME)) == -1) lprof[0] = 0;
	else ::lstrcpyn(lprof, (LPCSTR)ret, 0x20); lprof[0x20] = 0;
	if((ret = SWRSGetParam(SWRSPARAM_RPROFNAME)) == -1) rprof[0] = 0;
	else ::lstrcpyn(rprof, (LPCSTR)ret, 0x20); rprof[0x20] = 0;

	int lwin = SWRSGetParam(SWRSPARAM_LWINCOUNT);
	int rwin = SWRSGetParam(SWRSPARAM_RWINCOUNT);
	int lid  = SWRSGetParam(SWRSPARAM_LCHARID);
	int rid  = SWRSGetParam(SWRSPARAM_RCHARID);
	/* 臒l`FbN */
	if(lwin < 0 || lwin > 2 || rwin < 0 || rwin > 2) return;
	if(lid < 0 || lid >= SWRSCHAR_MAX || rid < 0 || rid >= SWRSCHAR_MAX) return;

	SCORELINE_ITEM item;

	SYSTEMTIME loctime;
	GetLocalTime(&loctime);
	SystemTimeToFileTime(&loctime, (LPFILETIME)&item.timestamp);
	if(comm == SWRSCOMMMODE_CLIENT) {
		/* ɂ */
		item.p1id = rid;
		item.p2id = lid;
		item.p1win = rwin;
		item.p2win = lwin;
		lstrcpy(item.p1name, rprof);
		lstrcpy(item.p2name, lprof);
	} else {
		/* Eɂ */
		item.p1id = lid;
		item.p2id = rid;
		item.p1win = lwin;
		item.p2win = rwin;
		lstrcpy(item.p1name, lprof);
		lstrcpy(item.p2name, rprof);
	}

	/* ΐ\XV */
	ScoreLine_Enter();
	bool failed = !ScoreLine_Append(&item);
	ScoreLine_Leave(failed);
	if(!failed) {
		Memento_Append(MEMENTO_CMD_APPEND, &item);
		::PostMessage(s_hScoreLineDlg, UM_UPDATESCORELINE, 0, 0);

		/* ʂNbv{[hɓ] */
		switch (s_infoTransfer) {
		case INFOTRANS_PROFILE:
			SetClipboardText(item.p2name, static_cast<DWORD>(-1));
			break;
		case INFOTRANS_ALL:
			SetClipboardText(Formatter("%s(%s) %d-%d %s(%s)", 
				item.p1name, g_characters[item.p1id].abbr,
				item.p1win, item.p2win,
				item.p2name, g_characters[item.p2id].abbr), static_cast<DWORD>(-1));
			break;
		}
	}
}

static void SWRS_OnStateChange(WORD param1)
{
	switch(param1) {
	case SWRSSTATE_NOTFOUND:
		s_nid.hIcon = 
			(HICON)LoadImage(g_hInstance, MAKEINTRESOURCE(IDI_IDLE), IMAGE_ICON, 16, 16, LR_SHARED);
#ifdef USE_AUTORUN
		Autorun_Enter(s_nid.hWnd, "Houkokutool");
		Autorun_Exit(s_nid.hWnd, "Tensokukan");
#endif
		break;
	case SWRSSTATE_WATCH:
		s_nid.hIcon = 
			(HICON)LoadImage(g_hInstance, MAKEINTRESOURCE(s_tcgLimit ? IDI_LIMIT : IDI_ACTIVE), IMAGE_ICON, 16, 16, LR_SHARED);
		break;
	}
	Shell_NotifyIcon(NIM_MODIFY, &s_nid);
}

static void SWRS_OnParamChange(WORD param1, LPARAM param2)
{
	switch(param1) {
	case SWRSPARAM_BATTLEMODE:
		if(param2 == 5) { /* og[hKO */
			int scene = SWRSGetParam(SWRSPARAM_SCENE);
			/* V[͒ʐMΐ풆 */
			if(scene == SWRSSCENE_BATTLESV || scene == SWRSSCENE_BATTLECL) {
				SWRS_OnKO();
			}
		}
		break;
	}
}

static void MainWindow_OnSWRSCallback(HWND hwnd, WORD Msg, WORD param1, LPARAM param2)
{
	if(s_disableSWRSCallback) return;
	switch(Msg) {
	case SWRSMSG_STATECHANGE: /* Xe[gω */
		SWRS_OnStateChange(param1);
		break;
	case SWRSMSG_PARAMCHANGE: /* p[^ω */
		SWRS_OnParamChange(param1, param2);
		break;
	}
}

static void NotifyMenu_OnInfoTransfer(HWND hwnd, int id)
{
	switch (id) {
	case ID_INFOTRANS_NONE: s_infoTransfer = INFOTRANS_NONE; break;
	case ID_INFOTRANS_PROFILE: s_infoTransfer = INFOTRANS_PROFILE; break;
	case ID_INFOTRANS_ALL: s_infoTransfer = INFOTRANS_ALL; break;
	}

	::CheckMenuItem(s_hPopupMenu, ID_INFOTRANS_NONE, s_infoTransfer == INFOTRANS_NONE ? MF_CHECKED : MF_UNCHECKED);
	::CheckMenuItem(s_hPopupMenu, ID_INFOTRANS_PROFILE, s_infoTransfer == INFOTRANS_PROFILE ? MF_CHECKED : MF_UNCHECKED);
	::CheckMenuItem(s_hPopupMenu, ID_INFOTRANS_ALL, s_infoTransfer == INFOTRANS_ALL ? MF_CHECKED : MF_UNCHECKED);

}

static void NotifyMenu_OnExit(HWND hwnd)
{
	::DestroyWindow(hwnd);
}

static void NotifyMenu_OnShowScoreLine(HWND hwnd)
{
	::ShowWindow(s_hScoreLineDlg, SW_SHOW);
	::SetForegroundWindow(s_hScoreLineDlg);
}

static void NotifyMenu_OnDisableSWRSCallback(HWND hwnd)
{
	s_disableSWRSCallback = !s_disableSWRSCallback;
	::CheckMenuItem(s_hPopupMenu, ID_DISABLE_SWRSCB,
		s_disableSWRSCallback ? MF_CHECKED : MF_UNCHECKED);
	SWRS_OnStateChange(s_disableSWRSCallback ? SWRSSTATE_NOTFOUND : SWRSAddrGetState());

}

static void NotifyMenu_OnTcgLimitter(HWND hwnd)
{
	s_tcgLimit = !s_tcgLimit;
	s_tcgCount = 0;
	::CheckMenuItem(s_hPopupMenu, ID_TCG_LIMITTER,
		s_tcgLimit ? MF_CHECKED : MF_UNCHECKED);
	SWRS_OnStateChange(SWRSAddrGetState());
}


static BOOL MainWindow_OnCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct)
{
	char profPathBuff[1025];
	g_settings.ReadString("General", "Profile", "", profPathBuff, sizeof profPathBuff);

	bool createProfile;
	Minimal::ProcessHeapPathA profPath;
	if(profPathBuff[0] == 0) {
		profPath = g_appPath;
		profPath /= "Default.db";
		createProfile = true;
	} else {
		profPath = profPathBuff;
		createProfile = false;
	}
	ScoreLine_SetPath(profPath);
	if(!ScoreLine_Open(createProfile)) {
		OPENFILENAME ofn;
		ZeroMemory(&ofn, sizeof ofn);
		ofn.lStructSize = sizeof ofn;
		ofn.hwndOwner = hwnd;
		ofn.lpstrFile = profPathBuff;
		ofn.nMaxFile = sizeof profPathBuff;
		ofn.lpstrDefExt = "db";
		ofn.lpstrFilter = "Trackrecord Database (*.db)\0*.db\0";
		ofn.Flags = OFN_CREATEPROMPT | OFN_NOCHANGEDIR;
		do {
			::MessageBox(hwnd, "vt@C̃}bsOɎs܂B", NULL, MB_OK | MB_ICONSTOP);
			if(!::GetOpenFileName(&ofn)) return FALSE;
			ScoreLine_SetPath(profPathBuff);
		} while(!ScoreLine_Open(true));
	}

	s_WM_TASKBAR_CREATED = RegisterWindowMessage("TaskbarCreated");

	s_nid.cbSize = sizeof(s_nid);
	s_nid.uID = 0;
	s_nid.uFlags = NIF_ICON | NIF_TIP | NIF_MESSAGE;
	s_nid.hIcon = (HICON)LoadImage(g_hInstance, MAKEINTRESOURCE(IDI_IDLE), IMAGE_ICON, 16, 16, LR_SHARED);
	s_nid.hWnd = hwnd;
	s_nid.uCallbackMessage = UM_NOTIFYICON;
	lstrcpy(s_nid.szTip, WINDOW_TEXT);
	if(!Shell_NotifyIcon(NIM_ADD, &s_nid)) return FALSE;

	HMENU hDummyMenu = LoadMenu(g_hInstance, MAKEINTRESOURCE(IDR_MENU));
	if(hDummyMenu == NULL) return FALSE;
	s_hPopupMenu = GetSubMenu(hDummyMenu, 0);
	if(s_hPopupMenu == NULL) return FALSE;

	s_hScoreLineDlg = CreateDialogA(
		g_hInstance,
		MAKEINTRESOURCE(IDD_SCORELINE_QIB),
		NULL, ScoreLineQIBDialog_DlgProc);
	if(!s_hScoreLineDlg) return FALSE;

	if(!SWRSAddrInit(hwnd, UM_SWRSCALLBACK)) return FALSE;

	s_tcgLimit = g_settings.ReadInteger("General", "tcgLimit", 0) != 0;
	s_tcgCount = 0;
	::CheckMenuItem(s_hPopupMenu, ID_TCG_LIMITTER,
		s_tcgLimit ? MF_CHECKED : MF_UNCHECKED);

	s_infoTransfer = static_cast<INFOTRANSTYPE>(g_settings.ReadInteger("General", "infoTrans", INFOTRANS_NONE));
	if (s_infoTransfer < INFOTRANS_NONE || s_infoTransfer > INFOTRANS_MAX) {
		s_infoTransfer = INFOTRANS_NONE;
	}
	::CheckMenuItem(s_hPopupMenu, ID_INFOTRANS_NONE, s_infoTransfer == INFOTRANS_NONE ? MF_CHECKED : MF_UNCHECKED);
	::CheckMenuItem(s_hPopupMenu, ID_INFOTRANS_PROFILE, s_infoTransfer == INFOTRANS_PROFILE ? MF_CHECKED : MF_UNCHECKED);
	::CheckMenuItem(s_hPopupMenu, ID_INFOTRANS_ALL, s_infoTransfer == INFOTRANS_ALL ? MF_CHECKED : MF_UNCHECKED);

	Minimal::ProcessHeapArrayT<SHORTCUT> scArray;
	for(int i = 0; i < MAX_SHORTCUT; ++i)
	{
		SHORTCUT sc;
		char key[16];
		::wsprintf(key, "Key%d", i);
		sc.accel = g_settings.ReadInteger("Shortcut", key, 0);
		if(!sc.accel) break;

		::wsprintf(key, "Path%d", i);
		g_settings.ReadString("Shortcut", key, "", sc.path, _countof(sc.path));
		if(!sc.path[0]) break;
		scArray.Push(sc);
	}
	Shortcut_Construct(scArray.GetRaw(), scArray.GetSize());

#ifdef USE_AUTORUN
	Autorun_CheckMenuItem(s_hPopupMenu, "Hisoutensoku", ID_AUTORUN_HISOUTENSOKU_FLIPENABLED);
	Autorun_CheckMenuItem(s_hPopupMenu, "Houkokutool", ID_AUTORUN_HOUKOKUTOOL_FLIPENABLED);
	Autorun_CheckMenuItem(s_hPopupMenu, "Tensokukan", ID_AUTORUN_TENSOKUKAN_FLIPENABLED);
	Autorun_Enter(hwnd, "Hisoutensoku");
#endif
	return TRUE;
}

static void MainWindow_OnDestroy(HWND hwnd)
{
	if(s_hScoreLineDlg)
		DestroyWindow(s_hScoreLineDlg);

	g_settings.WriteString("General", "Profile", ScoreLine_GetPath());
	g_settings.WriteInteger("General", "tcgLimit", s_tcgLimit);

	g_settings.WriteInteger("General", "InfoTrans", s_infoTransfer);

	int i, count = Shortcut_Count();
	char key[16];
	for(i = 0; i < count; ++i) {
		SHORTCUT sc;
		Shortcut_GetElement(sc, i);
		::wsprintf(key, "Key%d", i);
		g_settings.WriteInteger("Shortcut", key, sc.accel);
		::wsprintf(key, "Path%d", i);
		g_settings.WriteString("Shortcut", key, sc.path);
	}
	::wsprintf(key, "Key%d", i);
	g_settings.WriteString("Shortcut", key, NULL);
	::wsprintf(key, "Path%d", i);
	g_settings.WriteString("Shortcut", key, NULL);

	if(s_nid.cbSize) {
		Shell_NotifyIcon(NIM_DELETE, &s_nid);
	}

	SWRSAddrFinish();

	Shortcut_Finalize();

	ScoreLine_Close();

	::PostQuitMessage(0);
}

static void NotifyMenu_OnProfileSCKey(HWND hwnd)
{
	ShortcutDialog_ShowModeless(hwnd, NULL);
}

#ifdef USE_AUTORUN
static void NotifyMenu_OnAutorunHisoutensokuFlipEnabled(HWND hwnd)
{
	Autorun_FlipEnabled(s_hPopupMenu, "Hisoutensoku", ID_AUTORUN_HISOUTENSOKU_FLIPENABLED);
}

static void NotifyMenu_OnAutorunHisoutensokuOpenFileName(HWND hwnd)
{
	Autorun_OpenFileName(hwnd, "zV (th123.exe)\0th123.exe\0", "Hisoutensoku");
}

static void NotifyMenu_OnAutorunHoukokutoolFlipEnabled(HWND hwnd)
{
	Autorun_FlipEnabled(s_hPopupMenu, "Houkokutool", ID_AUTORUN_HOUKOKUTOOL_FLIPENABLED);
}

static void NotifyMenu_OnAutorunHoukokutoolOpenFileName(HWND hwnd)
{
	Autorun_OpenFileName(hwnd, "Vϕ񍐃c[ (tsk_report.exe)\0tsk_report.exe\0", "Houkokutool");
}

static void NotifyMenu_OnAutorunTensokukanFlipEnabled(HWND hwnd)
{
	Autorun_FlipEnabled(s_hPopupMenu, "Tensokukan", ID_AUTORUN_TENSOKUKAN_FLIPENABLED);
}
#endif

static void MainWindow_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{
	switch(id) {
	case ID_INFOTRANS_NONE:
	case ID_INFOTRANS_PROFILE:
	case ID_INFOTRANS_ALL:	NotifyMenu_OnInfoTransfer(hwnd, id); break;
	case ID_TCG_LIMITTER:	NotifyMenu_OnTcgLimitter(hwnd); break;
	case ID_DISABLE_SWRSCB:	NotifyMenu_OnDisableSWRSCallback(hwnd); break;
	case ID_SHOW_SCORELINE: NotifyMenu_OnShowScoreLine(hwnd); break;
	case ID_PROFSCKEY:		NotifyMenu_OnProfileSCKey(hwnd); break;
#ifdef USE_AUTORUN
	case ID_AUTORUN_HISOUTENSOKU_FLIPENABLED:	NotifyMenu_OnAutorunHisoutensokuFlipEnabled(hwnd); break;
	case ID_AUTORUN_HISOUTENSOKU_OPENFILENAME:	NotifyMenu_OnAutorunHisoutensokuOpenFileName(hwnd); break;
	case ID_AUTORUN_HOUKOKUTOOL_FLIPENABLED:	NotifyMenu_OnAutorunHoukokutoolFlipEnabled(hwnd); break;
	case ID_AUTORUN_HOUKOKUTOOL_OPENFILENAME:	NotifyMenu_OnAutorunHoukokutoolOpenFileName(hwnd); break;
	case ID_AUTORUN_TENSOKUKAN_FLIPENABLED:		NotifyMenu_OnAutorunTensokukanFlipEnabled(hwnd); break;
#endif
	case ID_EXIT:			NotifyMenu_OnExit(hwnd); break;
	}
}

static BOOL MainWindow_OnNotifyIcon(HWND hwnd, WPARAM id, LPARAM Msg)
{
	if(Msg == WM_RBUTTONDOWN) {
		POINT curPos;
		::GetCursorPos(&curPos);
		::SetForegroundWindow(hwnd);
		::TrackPopupMenu(s_hPopupMenu, TPM_LEFTBUTTON | TPM_TOPALIGN, curPos.x, curPos.y, 0, hwnd, NULL);
		::SendMessage(hwnd, WM_NULL, 0, 0);
	} else if(Msg == WM_LBUTTONDBLCLK) {
		NotifyMenu_OnShowScoreLine(hwnd);
	}
	return TRUE;
}

static BOOL MainWindow_OnUnhandled(HWND hwnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	if(Msg == s_WM_TASKBAR_CREATED) {
		::Shell_NotifyIcon(NIM_ADD, &s_nid);
		return TRUE;
	}
	else
	return FALSE;
}

LRESULT CALLBACK MainWindow_WndProc(HWND hwnd, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_MSG(hwnd, WM_CREATE,   MainWindow_OnCreate);
	HANDLE_MSG(hwnd, WM_DESTROY,  MainWindow_OnDestroy);
	HANDLE_MSG(hwnd, WM_COMMAND,  MainWindow_OnCommand);
	case UM_NOTIFYICON:  return MainWindow_OnNotifyIcon(hwnd, wParam, lParam);
	case UM_SWRSCALLBACK: return MainWindow_OnSWRSCallback(hwnd, LOWORD(wParam), HIWORD(wParam), lParam), 0L;
	}
	return MainWindow_OnUnhandled(hwnd, Msg, wParam, lParam) ? 0
		 : ::DefWindowProc(hwnd, Msg, wParam, lParam);

}

bool MainWindow_PreTranslateMessage(MSG &msg)
{
	HACCEL accel = Shortcut_GetAccelHandle();
	return !TranslateAccelerator(s_hScoreLineDlg, accel, &msg) && !IsDialogMessage(msg.hwnd, &msg);
}

bool MainWindow_Initialize()
{
	::InitCommonControls();

	WNDCLASS wc;
	ZeroMemory(&wc, sizeof wc);
	wc.hInstance = g_hInstance;
	wc.lpfnWndProc = MainWindow_WndProc;
	wc.lpszClassName = WINDOW_CLASS;
	if(::RegisterClass(&wc) == (ATOM)0) return false;

	HWND hMainWnd = ::CreateWindowA(
		WINDOW_CLASS, NULL, WS_POPUP,
		CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, CW_USEDEFAULT,
		NULL, NULL, g_hInstance, NULL);
	if(!hMainWnd) return false;

	return true;
}
