#include "pch.hpp"

#ifdef USE_AUTORUN

#include "autorun.hpp"
#include "AlwaysRecordable.hpp"

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalString.hpp"

static void Autorun_MakeProfileKey(char* profileKey, size_t profileKeySize, const char* highProfileKey, const char* lowProfileKey)
{
	Minimal::ProcessHeapStringA profileKeyString;
	profileKeyString += highProfileKey;
	profileKeyString += ".";
	profileKeyString += lowProfileKey;
	lstrcpyn(profileKey, profileKeyString.GetRaw(), profileKeySize);
}

void Autorun_CheckMenuItem(HMENU hmenu, const char* highProfileKey, UINT checkedMenuItem)
{
	char enabledProfileKey[MAX_PATH];
	Autorun_MakeProfileKey(enabledProfileKey, _countof(enabledProfileKey), highProfileKey, "Enabled");
	UINT enabled = g_settings.ReadInteger("Autorun", enabledProfileKey, FALSE);
	::CheckMenuItem(hmenu, checkedMenuItem, ((enabled) ? (MF_CHECKED) : (MF_UNCHECKED)));
}

void Autorun_Enter(HWND hwnd, const char* highProfileKey)
{
	// TCY 1025 ɂĂX^bNsŃRpCłȂĐ
	char enabledProfileKey[MAX_PATH];
	Autorun_MakeProfileKey(enabledProfileKey, _countof(enabledProfileKey), highProfileKey, "Enabled");
	UINT enabled = g_settings.ReadInteger("Autorun", enabledProfileKey, FALSE);
	if (enabled) {
		char fileNameProfileKey[MAX_PATH];
		Autorun_MakeProfileKey(fileNameProfileKey, _countof(fileNameProfileKey), highProfileKey, "FileName");
		char fileName[MAX_PATH];
		g_settings.ReadString("Autorun", fileNameProfileKey, "", fileName, _countof(fileName));
		if (::lstrcmp(fileName, "") != 0) {
			char directoryName[MAX_PATH];
			::lstrcpyn(directoryName, fileName, _countof(directoryName));
			::PathRemoveFileSpec(directoryName);
			::ShellExecute(hwnd, "open", fileName, NULL, directoryName, SW_SHOWNORMAL);
		}
	}
}

void Autorun_Exit(HWND hwnd, const char* highProfileKey)
{
	char enabledProfileKey[MAX_PATH];
	Autorun_MakeProfileKey(enabledProfileKey, _countof(enabledProfileKey), highProfileKey, "Enabled");
	UINT enabled = g_settings.ReadInteger("Autorun", enabledProfileKey, FALSE);
	if (enabled) {
		::DestroyWindow(hwnd);
	}
}

void Autorun_FlipEnabled(HMENU hmenu, const char* highProfileKey, UINT checkedMenuItem)
{
	char enabledProfileKey[MAX_PATH];
	Autorun_MakeProfileKey(enabledProfileKey, _countof(enabledProfileKey), highProfileKey, "Enabled");
	UINT enabled = g_settings.ReadInteger("Autorun", enabledProfileKey, FALSE);
	g_settings.WriteInteger("Autorun", enabledProfileKey, !enabled);
	Autorun_CheckMenuItem(hmenu, highProfileKey, checkedMenuItem);
}

void Autorun_OpenFileName(HWND hwnd, const char* openedFileFilter, const char* highProfileKey)
{
	char fileName[MAX_PATH];
	OPENFILENAME ofn;
	::ZeroMemory(&ofn, sizeof ofn);
	ofn.lStructSize = sizeof ofn;
	ofn.hwndOwner = hwnd;
	ofn.lpstrFile = fileName;
	ofn.nMaxFile = sizeof fileName;
	ofn.lpstrDefExt = "exe";
	ofn.lpstrFilter = openedFileFilter;
	ofn.Flags = OFN_CREATEPROMPT | OFN_NOCHANGEDIR;
	fileName[0] = 0;
	if (::GetOpenFileName(&ofn)) {
		char fileNameProfileKey[MAX_PATH];
		Autorun_MakeProfileKey(fileNameProfileKey, _countof(fileNameProfileKey), highProfileKey, "FileName");
		g_settings.WriteString("Autorun", fileNameProfileKey, fileName);
	}
}

#endif
