#include "pch.hpp"
#include "ProfileIO.hpp"

CProfileIO::CProfileIO()
{
}

CProfileIO::CProfileIO(LPCSTR path)
{
	SetPath(path);
}

BOOL CProfileIO::SetPath(LPCSTR path)
{
	m_path = path;
	return TRUE;
}

LPCSTR CProfileIO::GetPath()
{
	return m_path;
}

DWORD CProfileIO::ReadString(LPCSTR sec, LPCSTR key, LPCSTR def, LPSTR buf, DWORD len)
{
	return ::GetPrivateProfileString(sec, key, def, buf, len, m_path);
}

UINT CProfileIO::ReadInteger(LPCSTR sec, LPCSTR key, INT def)
{
	return ::GetPrivateProfileInt(sec, key, def, m_path);
}

DWORD CProfileIO::WriteString(LPCSTR sec, LPCSTR key, LPCSTR value)
{
	return ::WritePrivateProfileString(sec, key, value, m_path);
}

DWORD CProfileIO::WriteInteger(LPCSTR sec, LPCSTR key, INT value)
{
	char buff[16];
	::wnsprintf(buff, sizeof buff, "%d", value);
	return ::WritePrivateProfileString(sec, key, buff, m_path);
}

