#include "pch.hpp"
#include "AlwaysRecordable.hpp"
#include "mainwnd.hpp"
#include "scorelinedlg.hpp"
#include "qibfilterdlg.hpp"
#include "rankprofdlg.hpp"
#include "trfilterdlg.hpp"
#include "scoreline.hpp"
#include "shortcut.hpp"
#include "Formatter.hpp"
#include "characters.hpp"
#include "memento.hpp"
#include "clipboard.hpp"
#include "SWRSAddrDef.h"
#include "resource.h"

#define MINIMAL_USE_PROCESSHEAPARRAY
#include "MinimalArray.hpp"

#define UC_OPENHIT 0xB000

#define UC_UNDOSCR 0xC000
#define UC_REDOSCR 0xC001

#define UC_VIEWALL 0xD000
#define UC_VIEWTOD 0xD001
#define UC_VIEWYES 0xD002
#define UC_VIEWCST 0xD003
#define UC_VIEWMAX 0xD004

#define UC_RNKPROF 0xE000
#define UC_TRKRECD 0xE001

#define UC_CLIPBRD 0xE010

#define EVEN_COLOR 0xFFFFFF
#define ODD_COLOR  0xD0DCD0

typedef Minimal::ProcessHeapArrayT<SCORELINE_FILTER> ScoreLineFilterArray;

enum QIB_VIEWMODE {
	QIB_VIEW_ALL,
	QIB_VIEW_TODAY,
	QIB_VIEW_YESTERDAY,
	QIB_VIEW_CUSTOM,
};

static struct {
	DWORD fmt;
	int cx;
	LPCSTR text;
} s_listColumns[] = {
	{ LVCFMT_LEFT,   80, "O" },
	{ LVCFMT_RIGHT,  55, "ΐ퐔" },
	{ LVCFMT_RIGHT,  55, "" },
	{ LVCFMT_RIGHT,  55, "" },
	{ LVCFMT_RIGHT,  55, "" },
	{ LVCFMT_RIGHT,  55, "ߋ30" },
};

static HMENU s_hSysMenu;
static DWORD s_viewMode;
static SCORELINE_FILTER_DESC s_custFilters;

static void ScoreLine_AppendViewFilter(SCORELINE_FILTER_DESC &ret)
{
	SYSTEMTIME loctime, begin, end;
	switch(s_viewMode) {
	case QIB_VIEW_TODAY:
		ret.mask |= SCORELINE_FILTER__TIMESTAMP_BEGIN | SCORELINE_FILTER__TIMESTAMP_END;
		// n_
		GetLocalTime(&loctime);
		begin = loctime;
		begin.wHour =
		begin.wMinute = 
		begin.wSecond =
		begin.wMilliseconds = 0;
		SystemTimeToFileTime(&begin, (LPFILETIME)&ret.t_begin);
		// I_
		end = loctime;
		end.wHour = 23;
		end.wMinute = 59;
		end.wSecond = 59;
		end.wMilliseconds = 999;
		SystemTimeToFileTime(&end, (LPFILETIME)&ret.t_end);
		break;
	case QIB_VIEW_YESTERDAY:
		ret.mask |= SCORELINE_FILTER__TIMESTAMP_BEGIN | SCORELINE_FILTER__TIMESTAMP_END;
		// n_
		GetLocalTime(&loctime);
		begin = loctime;
		begin.wHour =
		begin.wMinute = 
		begin.wSecond =
		begin.wMilliseconds = 0;
		SystemTimeToFileTime(&begin, (LPFILETIME)&ret.t_begin);
		/* 24 x 60 x 60b x 1000~b x 1000}CNb x 10imb */
		ret.t_begin -= 864000000000ULL; 
		// I_
		end = loctime;
		end.wHour = 23;
		end.wMinute = 59;
		end.wSecond = 59;
		end.wMilliseconds = 999;
		SystemTimeToFileTime(&end, (LPFILETIME)&ret.t_end);
		ret.t_end -= 864000000000ULL;
		break;
	case QIB_VIEW_CUSTOM:
		ret <<= s_custFilters;
		break;
	}
}

static void SysMenu_OnClose(HWND hDlg, int x, int y)
{
	ShowWindow(hDlg, SW_HIDE);
}

static LRESULT ScoreLineView_OnCustomDraw(HWND hParent, HWND hwnd, LPNMLVCUSTOMDRAW lpnlvCustomDraw)
{
	switch(lpnlvCustomDraw->nmcd.dwDrawStage) {
	case CDDS_PREPAINT:
		return CDRF_NOTIFYITEMDRAW;
	case CDDS_ITEMPREPAINT:
		if(lpnlvCustomDraw->nmcd.dwItemSpec & 1)
			lpnlvCustomDraw->clrTextBk = EVEN_COLOR;
		else
			lpnlvCustomDraw->clrTextBk = ODD_COLOR;
		return CDRF_NOTIFYSUBITEMDRAW;
	default:
		return CDRF_DODEFAULT;
	}
}

static LRESULT ScoreLIneView_OnDoubleClick(HWND hParent, HWND hwnd)
{
	int index = ListView_GetSelectionMark(hwnd);
	if(index >= 0 && index < SWRSCHAR_MAX) {
		// tB^(1Pi荞)ݒ
		SCORELINE_FILTER_DESC *pfilterDesc = new SCORELINE_FILTER_DESC;
		pfilterDesc->mask = SCORELINE_FILTER__P1ID;
		pfilterDesc->p1id = index;
		ScoreLine_AppendViewFilter(*pfilterDesc);
		HWND hSpecDlg = CreateDialogParam(
			g_hInstance,
			MAKEINTRESOURCE(IDD_SCORELINE_QIB),
			hParent,
			ScoreLineQIBSpecDialog_DlgProc,
			(LPARAM)pfilterDesc);
		ShowWindow(hSpecDlg, SW_SHOW);
	}
	return TRUE;
}

__inline
static void ScoreLineQIBDialog_RefleshUnit(HWND listWnd, int i, int win, int lose)
{
	Minimal::ProcessHeapStringT<char> itemstr;

	LVITEM item;
	item.mask = LVIF_TEXT;
	item.cchTextMax = 256;

	int sum = win + lose;
	// ΐ퐔
	itemstr = Formatter("%d", sum);
	item.iItem = i;
	item.iSubItem = 1;
	item.pszText = (LPSTR)itemstr;
	ListView_SetItem(listWnd, &item);
	// 
	itemstr = Formatter("%d", win);
	item.iSubItem = 2;
	item.pszText = (LPSTR)itemstr;
	ListView_SetItem(listWnd, &item);
	// 
	itemstr = Formatter("%d", lose);
	item.iSubItem = 3;
	item.pszText = (LPSTR)itemstr;
	ListView_SetItem(listWnd, &item);
	// 
	itemstr = 
		Formatter("%d%%", 
			::MulDiv(win, 100, sum ? sum : 1));
	item.iSubItem = 4;
	item.pszText = (LPSTR)itemstr;
	ListView_SetItem(listWnd, &item);
}

static void ScoreLineQIBDialog_Reflesh(HWND hDlg)
{
	Minimal::ProcessHeapStringT<char> baseName;
	baseName = ScoreLine_GetPath();
	::PathStripPath(baseName);
	::PathRemoveExtension(baseName);
	baseName.Repair();
	::SetWindowText(hDlg,
		Formatter(WINDOW_TEXT " - %s",
			static_cast<LPCSTR>(baseName)));

	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);

	ScoreLine_Enter();

	int sumWinAll, sumLoseAll;
	{
		SCORELINE_FILTER_DESC filterDesc;
		filterDesc.mask = 0;
		ScoreLine_AppendViewFilter(filterDesc);
		if(!ScoreLine_QueryTrackRecord(filterDesc))
			goto exception;

		sumWinAll = sumLoseAll = 0;
		for(int i = 0; i < SWRSCHAR_MAX; ++i) {
			int sumWin, sumLose;
			sumWin = sumLose = 0;
			for(int j = 0; j < SWRSCHAR_MAX; ++j) {
				sumWin  += ScoreLine_Read(i, j, 0);
				sumLose += ScoreLine_Read(i, j, 1);
			}
			sumWinAll  += sumWin;
			sumLoseAll += sumLose;
			ScoreLineQIBDialog_RefleshUnit(listWnd, i, sumWin, sumLose);
		}
		ScoreLineQIBDialog_RefleshUnit(listWnd, SWRSCHAR_MAX + 1, sumWinAll, sumLoseAll);
	}

	LVITEM item;
	item.mask = LVIF_TEXT;
	item.cchTextMax = 256;

	// ߋ30폟()
	{
		Minimal::ProcessHeapStringT<char> itemstr;
		sumWinAll = sumLoseAll = 0;
		SCORELINE_FILTER_DESC filterDesc;
		filterDesc.mask  = SCORELINE_FILTER__P1ID | SCORELINE_FILTER__LIMIT;
		filterDesc.limit = 30;
		ScoreLine_AppendViewFilter(filterDesc);
		for(int i = 0; i < SWRSCHAR_MAX; ++i) {
			filterDesc.p1id = i;
			if(!ScoreLine_QueryTrackRecord(filterDesc))
				goto exception;

			int sumWin, sumLose, sum;
			sumWin = sumLose = 0;
			for(int j = 0; j < SWRSCHAR_MAX; ++j) {
				sumWin  += ScoreLine_Read(i, j, 0);
				sumLose += ScoreLine_Read(i, j, 1);
			}
			sumWinAll  += sumWin;
			sumLoseAll += sumLose;
			sum = sumWin + sumLose;
			itemstr = 
				Formatter("(%d%%)", 
					::MulDiv(sumWin, 100, sum ? sum : 1));
			item.iItem = i;
			item.iSubItem = 5;
			item.pszText = (LPSTR)itemstr;
			ListView_SetItem(listWnd, &item);
		}
	}
	// ߋ30폟
	{
		SCORELINE_FILTER_DESC filterDesc;
		filterDesc.mask = SCORELINE_FILTER__LIMIT;
		filterDesc.limit = 30;
		ScoreLine_AppendViewFilter(filterDesc);
		if(!ScoreLine_QueryTrackRecord(filterDesc))
			goto exception;
		sumWinAll = sumLoseAll = 0;
		for(int i = 0; i < SWRSCHAR_MAX; ++i) {
			int sumWin, sumLose;
			sumWin = sumLose = 0;
			for(int j = 0; j < SWRSCHAR_MAX; ++j) {
				sumWin  += ScoreLine_Read(i, j, 0);
				sumLose += ScoreLine_Read(i, j, 1);
			}
			sumWinAll  += sumWin;
			sumLoseAll += sumLose;
		}
		ScoreLineQIBDialog_RefleshUnit(listWnd, SWRSCHAR_MAX + 2, sumWinAll, sumLoseAll);
	}

	// ߋ50폟
	{
		SCORELINE_FILTER_DESC filterDesc;
		filterDesc.mask = SCORELINE_FILTER__LIMIT;
		filterDesc.limit = 50;
		ScoreLine_AppendViewFilter(filterDesc);
		if(!ScoreLine_QueryTrackRecord(filterDesc))
			goto exception;
		sumWinAll = sumLoseAll = 0;
		for(int i = 0; i < SWRSCHAR_MAX; ++i) {
			int sumWin, sumLose;
			sumWin = sumLose = 0;
			for(int j = 0; j < SWRSCHAR_MAX; ++j) {
				sumWin  += ScoreLine_Read(i, j, 0);
				sumLose += ScoreLine_Read(i, j, 1);
			}
			sumWinAll  += sumWin;
			sumLoseAll += sumLose;
		}
		ScoreLineQIBDialog_RefleshUnit(listWnd, SWRSCHAR_MAX + 3, sumWinAll, sumLoseAll);
	}

	{
		SCORELINE_FILTER_DESC filterDesc;
		filterDesc.mask = SCORELINE_FILTER__LIMIT;
		filterDesc.limit = 100;
		ScoreLine_AppendViewFilter(filterDesc);
		// ߋ100폟
		if(!ScoreLine_QueryTrackRecord(filterDesc))
			goto exception;
		sumWinAll = sumLoseAll = 0;
		for(int i = 0; i < SWRSCHAR_MAX; ++i) {
			int sumWin, sumLose;
			sumWin = sumLose = 0;
			for(int j = 0; j < SWRSCHAR_MAX; ++j) {
				sumWin  += ScoreLine_Read(i, j, 0);
				sumLose += ScoreLine_Read(i, j, 1);
			}
			sumWinAll  += sumWin;
			sumLoseAll += sumLose;
		}
		ScoreLineQIBDialog_RefleshUnit(listWnd, SWRSCHAR_MAX + 4, sumWinAll, sumLoseAll);
	}

	ScoreLine_Leave(false);
	return;
exception:
	ScoreLine_Leave(true);
	MessageBox(hDlg, "ѕ\̍XVɎs܂", NULL, MB_OK | MB_ICONSTOP);
}

static BOOL CALLBACK ScoreLineQIBDialog_CloseSubDialogProc(HWND hwnd, LPARAM lParam)
{
	if (GetParent(hwnd) == (HWND)lParam && (GetWindowLong(hwnd, GWL_STYLE) & WS_POPUPWINDOW)) {
		DestroyWindow(hwnd);
	}
	return TRUE;
}

static void ScoreLineQIBDialog_CloseSubDialog(HWND hDlg)
{
	EnumThreadWindows(GetCurrentThreadId(), ScoreLineQIBDialog_CloseSubDialogProc, (LPARAM)hDlg);
}

static BOOL ScoreLineQIBDialog_InitListView(HWND hDlg)
{
	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	ListView_SetExtendedListViewStyle(listWnd, LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);

	LVCOLUMN column;
	column.mask	= LVCF_FMT | LVCF_TEXT | LVCF_WIDTH;
	for(int i = 0; i < ARRAYSIZE(s_listColumns); ++i) {
		column.fmt = s_listColumns[i].fmt;
		column.cx = s_listColumns[i].cx;
		column.cchTextMax = 256;
		column.pszText = (LPSTR)s_listColumns[i].text;
		ListView_InsertColumn(listWnd, i, &column);
	}

	LVITEM item;
	item.mask = LVIF_TEXT;
	item.cchTextMax = 256;
	item.iSubItem = 0;
	for(int i = 0; i < ARRAYSIZE(g_characters); ++i) {
		item.pszText = (LPSTR)g_characters[i].abbr;
		item.iItem = i;
		ListView_InsertItem(listWnd, &item);
	}
	item.mask = 0; item.iItem++;
	ListView_InsertItem(listWnd, &item);

	item.mask = LVIF_TEXT; item.iItem++;
	item.pszText = "";
	ListView_InsertItem(listWnd, &item);

	item.pszText = "ߋ30"; item.iItem++; 
	ListView_InsertItem(listWnd, &item);
	item.pszText = "ߋ50"; item.iItem++; 
	ListView_InsertItem(listWnd, &item);
	item.pszText = "ߋ100"; item.iItem++; 
	ListView_InsertItem(listWnd, &item);

	return TRUE;
}

static void ScoreLineQIBDialog_OpenProfile(HWND hDlg, LPCSTR fileName)
{
	Minimal::ProcessHeapStringT<char> oldPath(ScoreLine_GetPath());
	ScoreLine_SetPath(fileName);
	if(ScoreLine_Open(true)) {
		Memento_Reset();
		ScoreLineQIBDialog_CloseSubDialog(hDlg);
		ScoreLineQIBDialog_Reflesh(hDlg);
	} else {
		ScoreLine_SetPath(oldPath);
		MessageBox(hDlg, "vt@C̃}bsOɎs܂B", NULL, MB_OK | MB_ICONSTOP);
	}
}

static void SysMenu_OnOpenProfile(HWND hDlg, int x, int y)
{
	char fileName[1025];
	OPENFILENAME ofn;
	::ZeroMemory(&ofn, sizeof ofn);
	ofn.lStructSize = sizeof ofn;
	ofn.hwndOwner = hDlg;
	ofn.lpstrFile = fileName;
	ofn.nMaxFile = sizeof fileName;
	ofn.lpstrDefExt = "db";
	ofn.lpstrFilter = "Trackrecord Database (*.db)\0*.db\0";
	ofn.Flags = OFN_CREATEPROMPT | OFN_NOCHANGEDIR;
	fileName[0] = 0;
	if(::GetOpenFileName(&ofn)) {
		ScoreLineQIBDialog_OpenProfile(hDlg, fileName);
	}
}

static void SysMenu_OnView(HWND hDlg, int nID, int x, int y)
{
	int newMode = nID - UC_VIEWALL;
	if(newMode != s_viewMode) {
		::CheckMenuItem(s_hSysMenu, nID, MF_CHECKED);
		for(int i = UC_VIEWALL; i < UC_VIEWMAX; ++i)
			if(i != nID) ::CheckMenuItem(s_hSysMenu, i, MF_UNCHECKED);
		s_viewMode = newMode;
		ScoreLineQIBDialog_Reflesh(hDlg);
	}
}

static void SysMenu_OnViewCustom(HWND hDlg, int nID, int x, int y)
{
	if(
	::DialogBoxA(
	  g_hInstance,
	  MAKEINTRESOURCE(IDD_QIBFILTER),
	  hDlg,
	  QIBFilterDlg_DlgProc) == IDOK) {
		s_custFilters.mask = 0;
		if(g_fltP2NameEnabled) {
			s_custFilters.mask |= SCORELINE_FILTER__P2NAME;
			::lstrcpy(s_custFilters.p2name, g_fltP2Name);
		}
		if(g_fltDateBeginEnabled) {
			s_custFilters.mask |= SCORELINE_FILTER__TIMESTAMP_BEGIN;
			s_custFilters.t_begin = g_fltDateBegin;
		}
		if(g_fltDateEndEnabled) {
			s_custFilters.mask |= SCORELINE_FILTER__TIMESTAMP_END;
			s_custFilters.t_end = g_fltDateEnd;
		}
		::CheckMenuItem(s_hSysMenu, nID, MF_CHECKED);
		for(int i = UC_VIEWALL; i < UC_VIEWMAX; ++i)
			if(i != nID) ::CheckMenuItem(s_hSysMenu, i, MF_UNCHECKED);
		s_viewMode = QIB_VIEW_CUSTOM;
		ScoreLineQIBDialog_Reflesh(hDlg);
	}
}

static void SysMenu_OnUndo(HWND hDlg, int x, int y)
{
	Memento_Undo();
	ScoreLineQIBDialog_Reflesh(hDlg);
}

static void SysMenu_OnRedo(HWND hDlg, int x, int y)
{
	Memento_Redo();
	ScoreLineQIBDialog_Reflesh(hDlg);
}

static void SysMenu_OnRankProfile(HWND hDlg, int x, int y)
{
	HWND hRankDlg = ::CreateDialog(g_hInstance, MAKEINTRESOURCE(IDD_SCORELINE_QIB), hDlg, RankProfDialog_DlgProc);
	::ShowWindow(hRankDlg, SW_SHOW);
}

static void SysMenu_OnTrackRecord(HWND hDlg, int x, int y)
{
	TrackRecordFilterDialog_ShowModal(hDlg, NULL);
	//TrackRecordDialog_ShowModeless(hDlg, NULL);
}

static void SysMenu_OnCopyClipboard(HWND hDlg, int x, int y)
{
	Minimal::ProcessHeapStringA result;

	for(int i = 0; i < _countof(s_listColumns); ++i) {
		if(s_listColumns[i].fmt == LVCFMT_LEFT) {
			result += s_listColumns[i].text;
			for(int j = ::lstrlen(s_listColumns[i].text); j < s_listColumns[i].cx / 7; ++j)
				result += " ";
		} else {
			for(int j = ::lstrlen(s_listColumns[i].text); j < s_listColumns[i].cx / 7; ++j)
				result += " ";
			result += s_listColumns[i].text;
		}
	}
	result += "\x0D\x0A";

	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	int count = ListView_GetItemCount(listWnd);

	for(int i = 0; i < count; ++i) {
		for(int j = 0; j < _countof(s_listColumns); ++j) {
			TCHAR text[64];
			ListView_GetItemText(listWnd, i, j, text, _countof(text));
			if(s_listColumns[j].fmt == LVCFMT_LEFT) {
				result += text;
				for(int k = ::lstrlen(text); k < s_listColumns[j].cx / 7; ++k)
					result += " ";
			} else {
				for(int k = ::lstrlen(text); k < s_listColumns[j].cx / 7; ++k)
					result += " ";
				result += text;
			}
		}
		result += "\x0D\x0A";
	}
	SetClipboardText(result, result.GetSize());
}

static void ScoreLineQIBDialog_InitSysMenu(HWND hDlg)
{
	int itemIndex = 0;
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_OPENHIT, "vt@Cǂݍ");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION | MF_CHECKED, UC_VIEWALL, "SĂ̑ΐ");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_VIEWTOD, "̑ΐ");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_VIEWYES, "̑ΐ");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_VIEWCST, "JX^ΐ");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_UNDOSCR, "ɖ߂");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_REDOSCR, "蒼");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_RNKPROF, "vt@C\");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_TRKRECD, "ߋΐ헚\");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	::InsertMenu(s_hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_CLIPBRD, "Nbv{[hɑ");
	::InsertMenu(s_hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
}

static BOOL ScoreLineQIBDialog_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
	s_hSysMenu = ::GetSystemMenu(hDlg, FALSE);
	if(s_hSysMenu == NULL) return FALSE;

	int x, y;
	x = g_settings.ReadInteger("QIBDlg.Display", "X", CW_USEDEFAULT);
	y = g_settings.ReadInteger("QIBDlg.Display", "Y", CW_USEDEFAULT);
	if(x != CW_USEDEFAULT && y != CW_USEDEFAULT)
		SetWindowPos(hDlg, 0, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER);

	s_viewMode = QIB_VIEW_ALL;

	ScoreLineQIBDialog_InitSysMenu(hDlg);
	ScoreLineQIBDialog_InitListView(hDlg);
	ScoreLineQIBDialog_Reflesh(hDlg);
	return TRUE;
}

static void ScoreLineQIBDialog_OnShortcut(HWND hDlg, int id)
{
	SHORTCUT sc;
	Shortcut_GetElement(sc, id - ID_SHORTCUT_BASE);
	ScoreLineQIBDialog_OpenProfile(hDlg, sc.path);
}

static void ScoreLineQIBDialog_OnCommand(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
{
	if(id >= ID_SHORTCUT_BASE && id < ID_SHORTCUT_BASE + MAX_SHORTCUT) {
		ScoreLineQIBDialog_OnShortcut(hDlg, id);
	}
}

static void ScoreLineQIBDialog_OnSysCommand(HWND hDlg, UINT nID, int x, int y)
{
	if(nID == SC_CLOSE) {
		SysMenu_OnClose(hDlg, x, y);
	} else if(nID == UC_OPENHIT) {
		SysMenu_OnOpenProfile(hDlg, x, y);
	} else if(nID >= UC_VIEWALL && nID <= UC_VIEWYES) {
		SysMenu_OnView(hDlg, nID, x, y);
	} else if(nID == UC_VIEWCST) {
		SysMenu_OnViewCustom(hDlg, nID, x, y);
	} else if(nID == UC_UNDOSCR) {
		SysMenu_OnUndo(hDlg, x, y);
	} else if(nID == UC_REDOSCR) {
		SysMenu_OnRedo(hDlg, x, y);
	} else if(nID == UC_RNKPROF) {
		SysMenu_OnRankProfile(hDlg, x, y);
	} else if(nID == UC_TRKRECD) {
		SysMenu_OnTrackRecord(hDlg, x, y);
	} else if(nID == UC_CLIPBRD) {
		SysMenu_OnCopyClipboard(hDlg, x, y);
	}
}

static LRESULT ScoreLineQIBDialog_OnNotify(HWND hDlg, int idCtrl, LPNMHDR pNMHdr)
{
	switch(idCtrl) {
	case IDC_LIST_SCORELINE:
		switch(pNMHdr->code) {
		case NM_CUSTOMDRAW:
			return ScoreLineView_OnCustomDraw(hDlg, pNMHdr->hwndFrom, (LPNMLVCUSTOMDRAW)pNMHdr);
		case NM_DBLCLK:
			return ScoreLIneView_OnDoubleClick(hDlg, pNMHdr->hwndFrom);
		}
		break;
	}
	return FALSE;
}

static void ScoreLineQIBDialog_OnDestroy(HWND hDlg)
{
	RECT rct;
	GetWindowRect(hDlg, &rct);
	g_settings.WriteInteger("QIBDlg.Display", "X", rct.left);
	g_settings.WriteInteger("QIBDlg.Display", "Y", rct.top);

}

static void ScoreLineQIBDialog_OnUpdateScoreLine(HWND hDlg)
{
	ScoreLineQIBDialog_Reflesh(hDlg);
}

static void ScoreLineQIBDialog_OnNCRButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT codeHitTest)
{
	if(codeHitTest == HTCAPTION) {
		EnableMenuItem(s_hSysMenu, UC_UNDOSCR, Memento_Undoable() ? MF_ENABLED : MF_GRAYED);
		EnableMenuItem(s_hSysMenu, UC_REDOSCR, Memento_Redoable() ? MF_ENABLED : MF_GRAYED);
	}
}


BOOL CALLBACK ScoreLineQIBDialog_DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_DLG_MSG(hDlg, WM_INITDIALOG, ScoreLineQIBDialog_OnInitDialog);
	HANDLE_DLG_MSG(hDlg, WM_DESTROY, ScoreLineQIBDialog_OnDestroy);
	HANDLE_DLG_MSG(hDlg, WM_COMMAND, ScoreLineQIBDialog_OnCommand);
	HANDLE_DLG_MSG(hDlg, WM_SYSCOMMAND, ScoreLineQIBDialog_OnSysCommand);
	HANDLE_DLG_MSG(hDlg, WM_NCRBUTTONDOWN, ScoreLineQIBDialog_OnNCRButtonDown);
	HANDLE_DLG_MSG(hDlg, WM_NOTIFY, ScoreLineQIBDialog_OnNotify);
	case UM_UPDATESCORELINE: ScoreLineQIBDialog_OnUpdateScoreLine(hDlg); break;
	}
	return FALSE;
}
