#include "pch.hpp"
#include "dlgcommon.hpp"
#include "qibfilterdlg.hpp"
#include "SWRSAddrDef.h"
#include "resource.h"

char   g_fltP2Name[SWRS_ADDR_PROFSIZE + 1];
time_t g_fltDateBegin;
time_t g_fltDateEnd;

bool   g_fltP2NameEnabled;
bool   g_fltDateBeginEnabled;
bool   g_fltDateEndEnabled;

static BOOL QIBFilterDlg_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
	::SendDlgItemMessage(hDlg, IDC_EDIT_P2NAME, EM_SETLIMITTEXT, 16, 0);
	return TRUE;
}

static void QIBFilterDlg_OnOK(HWND hDlg)
{
	SYSTEMTIME sysTime;

	g_fltP2NameEnabled =
		(::SendDlgItemMessage(hDlg, IDC_CHECK_P2NAME, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_fltDateBeginEnabled =
		(::SendDlgItemMessage(hDlg, IDC_CHECK_DATEBEG, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_fltDateEndEnabled =
		(::SendDlgItemMessage(hDlg, IDC_CHECK_DATEEND, BM_GETCHECK, 0, 0) == BST_CHECKED);
	
	if(g_fltDateBeginEnabled)
	{
		::SendDlgItemMessage(hDlg, IDC_DTP_DATEBEG, DTM_GETSYSTEMTIME, 0, (LPARAM)&sysTime);
		sysTime.wHour =
		sysTime.wMinute =
		sysTime.wSecond =
		sysTime.wMilliseconds = 0;
		::SystemTimeToFileTime(&sysTime, (LPFILETIME)&g_fltDateBegin);
	}

	if(g_fltDateEndEnabled)
	{
		::SendDlgItemMessage(hDlg, IDC_DTP_DATEEND, DTM_GETSYSTEMTIME, 0, (LPARAM)&sysTime);
		sysTime.wHour = 23;
		sysTime.wMinute = 59;
		sysTime.wSecond = 59;
		sysTime.wMilliseconds = 999;
		::SystemTimeToFileTime(&sysTime, (LPFILETIME)&g_fltDateEnd);

		if(g_fltDateBeginEnabled && g_fltDateBegin > g_fltDateEnd) {
			::MessageBox(hDlg, "n_͏I_OɂĂ", NULL, MB_OK | MB_ICONEXCLAMATION);
			return;
		}
	}

	if(g_fltP2NameEnabled) {
		::GetDlgItemText(hDlg, IDC_EDIT_P2NAME, g_fltP2Name, SWRS_ADDR_PROFSIZE);
	}

	::EndDialog(hDlg, IDOK);
}

static void QIBFilterDlg_OnCancel(HWND hDlg)
{
	::EndDialog(hDlg, IDCANCEL);
}

static void QIBFilterDlg_OnCheckP2Name(HWND hDlg)
{
	LRESULT oldState = 
		::SendDlgItemMessage(hDlg, IDC_CHECK_P2NAME, BM_GETCHECK, 0, 0);

	::SendDlgItemMessage(
		hDlg, IDC_CHECK_P2NAME,
		BM_SETCHECK,
		oldState == BST_CHECKED ? BST_UNCHECKED : BST_CHECKED, 0);

	::EnableWindow(GetDlgItem(hDlg, IDC_EDIT_P2NAME), oldState == BST_UNCHECKED);
}

static void QIBFilterDlg_OnCheckDateBegin(HWND hDlg)
{
	LRESULT oldState = 
		::SendDlgItemMessage(hDlg, IDC_CHECK_DATEBEG, BM_GETCHECK, 0, 0);

	::SendDlgItemMessage(
		hDlg, IDC_CHECK_DATEBEG,
		BM_SETCHECK,
		oldState == BST_CHECKED ? BST_UNCHECKED : BST_CHECKED, 0);

	::EnableWindow(GetDlgItem(hDlg, IDC_DTP_DATEBEG), oldState == BST_UNCHECKED);
}

static void QIBFilterDlg_OnCheckDateEnd(HWND hDlg)
{
	LRESULT oldState = 
		::SendDlgItemMessage(hDlg, IDC_CHECK_DATEEND, BM_GETCHECK, 0, 0);

	::SendDlgItemMessage(
		hDlg, IDC_CHECK_DATEEND,
		BM_SETCHECK,
		oldState == BST_CHECKED ? BST_UNCHECKED : BST_CHECKED, 0);

	::EnableWindow(GetDlgItem(hDlg, IDC_DTP_DATEEND), oldState == BST_UNCHECKED);
}

static void QIBFilterDlg_OnCommand(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
{
	switch(id) {
	case IDOK: QIBFilterDlg_OnOK(hDlg); break;
	case IDCANCEL: QIBFilterDlg_OnCancel(hDlg); break;
	case IDC_CHECK_P2NAME: QIBFilterDlg_OnCheckP2Name(hDlg); break;
	case IDC_CHECK_DATEBEG: QIBFilterDlg_OnCheckDateBegin(hDlg); break;
	case IDC_CHECK_DATEEND: QIBFilterDlg_OnCheckDateEnd(hDlg); break;
	}
}

BOOL CALLBACK QIBFilterDlg_DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_DLG_MSG(hDlg, WM_INITDIALOG, QIBFilterDlg_OnInitDialog);
	HANDLE_DLG_MSG(hDlg, WM_COMMAND, QIBFilterDlg_OnCommand);
	}
	return FALSE;
}
