#include <windows.h>
#include <tchar.h>
#include <atlcore.h>
#include <atlfile.h>
#include <atlcrypt.h>
#include <stlsoft/smartptr/scoped_handle.hpp>
#include <winstl/filesystem/path.hpp>
#include <winstl/system/system_directory.hpp>
#include <winstl/system/module_directory.hpp>
#include <winstl/system/module_filename.hpp>

static void *g_origFunc;
static const BYTE targetDigest[] =
{ 0xf3, 0x85, 0x5f, 0x88, 0x77, 0xa0, 0x13, 0x5e, 0xdb, 0xf2, 0xe0, 0xf8, 0xcf, 0x03, 0x59, 0xc4 };

extern "C" {
void __declspec(naked) __declspec(dllexport) Direct3DCreate9() { __asm { jmp g_origFunc } }
};

bool getSWRSHash(BYTE retVal[16])
{
	::ATL::CCryptProv prov;
	HRESULT hr = prov.Initialize();
	if (FAILED(hr)) {
		if (hr == NTE_BAD_KEYSET) {
			hr = prov.Initialize(PROV_RSA_FULL, NULL, MS_DEF_PROV, CRYPT_NEWKEYSET);
			if (FAILED(hr)) return false;
		} else {
			return false;
		}
	}

	{
		::ATL::CCryptMD5Hash hash;
		if (FAILED(hash.Initialize(prov))) return false;

		::winstl::module_filename SWRSPath(NULL);

		::ATL::CAtlFile file;
		if (FAILED(file.Create(SWRSPath.c_str(), GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING))) return false;

		for (;;) {
			BYTE buff[1024];
			DWORD readSize;
			if (FAILED(file.Read(buff, sizeof buff, readSize))) return false;
			if (readSize == 0) break;

			if (FAILED(hash.AddData(buff, readSize, 0))) return false;
		}

		DWORD hashLen = 16;
		if (FAILED(hash.GetValue(retVal, &hashLen))) return false;
	}
	return true;
}

BOOL Hook(HMODULE hToysModule)
{
	BYTE hash[16];
	if (!getSWRSHash(hash)) return FALSE;

	::winstl::system_directory systemDirPath;
	::winstl::path origModulePath(systemDirPath);
	origModulePath /= _T("D3D9.DLL");

	HMODULE origModule = ::LoadLibrary(origModulePath.c_str());
	if(!origModule) return FALSE;
	g_origFunc = ::GetProcAddress(origModule, "Direct3DCreate9");
	if(!g_origFunc) return FALSE;

	::winstl::module_directory appDirPath(NULL);
	::winstl::path settingPath(appDirPath);
	settingPath /= _T("SWRSToys.ini");

	TCHAR moduleKeys[1024];
	TCHAR moduleValue[MAX_PATH];
	::GetPrivateProfileString(_T("Module"), NULL, NULL, moduleKeys, sizeof moduleKeys, settingPath.c_str());
	for (TCHAR *key = moduleKeys; *key; key += ::_tcslen(key) + 1) {
		::winstl::path modulePath(appDirPath);
		::GetPrivateProfileString(_T("Module"), key, NULL, moduleValue, sizeof moduleValue, settingPath.c_str());
		modulePath /= moduleValue;

		::stlsoft::scoped_handle<HMODULE> hModule(::LoadLibrary(modulePath.c_str()), FreeLibrary);
		if (!hModule.empty()) {
			bool (*CheckVersion)(const BYTE hash[16]);
			bool (*Initialize)(HMODULE hMyModule, HMODULE hParentModule);
			*(FARPROC*)&CheckVersion = GetProcAddress(hModule.get(), "CheckVersion");
			*(FARPROC*)&Initialize = GetProcAddress(hModule.get(), "Initialize");
			if (
			CheckVersion && Initialize &&
			CheckVersion(hash) && Initialize(hModule.get(), hToysModule)) {
				hModule.detach();
			}
		}
	}

	return TRUE;
}

BOOL APIENTRY DllMain(HMODULE hModule, DWORD fdwReason, LPVOID lpReserved)
{
	return (fdwReason == DLL_PROCESS_ATTACH) ? Hook(hModule) : TRUE;
}
