#ifndef SWRS_H_INCLUDED
#define SWRS_H_INCLUDED

// ---------------- ev ----------------

// DWORD
__inline
DWORD TamperDword(DWORD addr, DWORD target)
{
	DWORD old = *(DWORD*)addr;
	*(DWORD*)addr = target;
	return old;
}

// DWORDZ
__inline
DWORD TamperDwordAdd(DWORD addr, DWORD delta)
{
	DWORD old = *(DWORD*)addr;
	*(DWORD*)addr += delta;
	return old;
}

// NEAR JMPIyh
__inline
DWORD TamperNearJmpOpr(DWORD addr, DWORD target)
{
	DWORD old = *(DWORD*)(addr + 1) + (addr + 5);
	*(DWORD*)(addr + 1) = target - (addr + 5);
	return old;
}

// NEAR JMP
__inline
void TamperNearJmp(DWORD addr, DWORD target)
{
	*(PBYTE)(addr + 0) = 0xE9;
	TamperNearJmpOpr(addr, target);
}

// NEAR CALL
__inline
void TamperNearCall(DWORD addr, DWORD target)
{
	*(PBYTE)(addr + 0) = 0xE8;
	TamperNearJmpOpr(addr, target);
}

// tHgfBXNv^
#pragma pack(push, 4)
struct SWRFONTDESC {
	char FaceName[0x100];
	BYTE R1;
	BYTE R2;
	BYTE G1;
	BYTE G2;
	BYTE B1;
	BYTE B2;
	LONG Height;
	LONG Weight;
	BYTE Italic;
	BYTE Shadow;
	BYTE UseOffset;
	DWORD BufferSize;
	DWORD OffsetX;
	DWORD OffsetY;
	DWORD CharSpaceX;
	DWORD CharSpaceY;
};

// RpNg
struct SWRSTR {
	union {
		char  str[16];
		char* pstr;
	};
	size_t length;

	operator char *() {
		return length > 15 ? pstr : str;
	}
};

// GtFNg}l[WC^[tF[X
struct __declspec(novtable) IEffectManager {
	virtual ~IEffectManager() {}
	virtual void LoadPattern(LPCSTR fileName, int) = 0;
	virtual void ClearPattern() = 0;
	virtual void AppendRegion(int arg_0, float arg_4, float arg_8, char arg_c, char arg_10, int arg_14) = 0;
	virtual void ClearRegion() = 0;
};

// t@C[_C^[tF[X
struct __declspec(novtable) IFileReader {
	virtual ~IFileReader() {}
	virtual bool Read(LPVOID lpBuffer, DWORD nNumberOfBytesToRead) = 0;
	virtual DWORD GetReadLength() = 0;
	virtual LONG Seek(LONG lDistanceToMove, DWORD dwMoveMethod) = 0;
	virtual DWORD GetLength() = 0;
};

// 悭킩Ȃ
struct UnknownF {
	void *Unknown[3];
	float Aaxis;
	float Baxis;
};

// static_assert
template<bool value>
struct static_assert { typedef struct assert_failed Type; };
template<>
struct static_assert<true> { typedef void* Type; };

// union_cast
template<typename TDest, typename TSrc>
__forceinline 	
TDest union_cast(TSrc src) {
	static_assert<sizeof(TDest) == sizeof(TSrc)>::Type 
		size_mismatch = 0;
	union {  TDest dst; TSrc src; } c;
	c.src = src;
	return c.dst;
}

// thiscall
class C {};
#define Ccall(p,f,r,T) (((C*)p)->*union_cast<r(C::*)T>(f))

// tHgIuWFNg\bh
#define SWRFont_Create(p) \
	Ccall(p,0x4111D0,void,())()
#define SWRFont_Destruct(p) \
	Ccall(p,0x411260,void,())()
#define SWRFont_SetIndirect(p, pdesc) \
	Ccall(p,0x411340,void,(void*))(pdesc)

// eNX`}l[W\bh
#define CTextureManager_LoadTexture(p, ret, path, unk1, unk2) \
	Ccall(p,0x405020,int*,(int*, LPCSTR, void*, void*))(ret, path, unk1, unk2)
#define CTextureManager_CreateTextTexture(p, ret, str, pdesc ,width ,height, p1, p2) \
	Ccall(p,0x405090,int*,(int*, LPCSTR, void*, int, int, int*, int*))(ret, str, pdesc, width, height, p1, p2)
#define CTextureManager_Remove(p, id) \
	Ccall(p,0x405100,void*,(int))(id)
#define CTextureManager_SetTexture(p, id, stage) \
	Ccall(p,0x405180,void,(int, int))(id, stage)
#define CTextureManager_GetSize(p, w, h) \
	Ccall(p,0x004051F0,void,(int*, int*))(w, h)
// eNX`}l[W\bh(nh}l[W̌p)
#define CTextureManager_Get(p, id) \
	((IDirect3DTexture9**)CHandleManager_Get(p, id))
#define CTextureManager_Allocate(p, id) \
	((IDirect3DTexture9**)CHandleManager_Allocate(p, id))
#define CTextureManager_Deallocate(p, id) \
	CHandleManager_Deallocate((void *)p, id)

// nh}l[W\bh
#define CHandleManager_Get(t, p, id) \
	Ccall(p,0x4175C0,t*,(int))(id)
 __declspec(naked) void**
Thunk_CHandleManager_Allocate(void *p, int *ret) {
	// thiscallȂ̂ɗƎvedigĂł@̊
	__asm push edi
	__asm mov edi, [esp+8]
	__asm push [esp+12]
	__asm mov eax, 0x4053F0
	__asm call eax
	__asm pop edi
	__asm retn
}
#define CHandleManager_Allocate(p, ret) \
	Thunk_CHandleManager_Allocate(p, ret)
 __declspec(naked) void
Thunk_CHandleManager_Deallocate(void *p, int id) {
	 // thiscall()eaxgĂł@̊
	__asm mov eax, [esp+4]
	__asm push [esp+8]
	__asm mov ecx, 0x417510
	__asm call ecx
	__asm retn
}
#define CHandleManager_Deallocate(p, id) \
	Thunk_CHandleManager_Deallocate(p, id)

// _\bh
#define CRenderer_Begin(p)  \
	Ccall(p,0x401000,bool,())()
#define CRenderer_End(p) \
	Ccall(p,0x401040,void,())()
/*
// ZNgGtFNg}l[W\bh
#define CSelectEffectManager_Create_Address 0x420CE0
#define CSelectEffectManager_Free_Address   0x4221F0
#define CSelectEffectManager_Create(p) \
	Ccall(p, CSelectEffectManager_Create_Address, void, ())()
*/

// Cvbg}l[W\bh
#define CInputManager_ReadReplay(p, name) \
	Ccall(p, 0x42EF60, bool,(char *))(name)

// xN^IuWFNg
#define Vector_Create \
	((void (__stdcall *)(void *, size_t, size_t, int, int))0x7EECAB)
#define Vector_Destruct \
	((void (__stdcall *)(void *, size_t, size_t, int))0x7EEC48)

// VXeL[Vbg
#define CheckKeyOneshot  \
	((bool(*)(int, int, int, int))0x43D670)
// pbg[h
#define LoadPackagePalette(pflag, name, pal, bpp) \
	Ccall(pflag, 0x408AF0, void, (LPCSTR, void *, int))(name, pal, bpp)

// f[^[h
#define LoadPackageFile(ppfile, name) \
	Ccall(ppfile, 0x40CDE0, bool, (LPCSTR))(name)

// LN^̎擾
#define GetCharacterAbbr \
	((LPCSTR (__cdecl *)(int id))0x43EBB0)

// og[hݒ
#define SetBattleMode \
	((void (__cdecl *)(int comm, int sub))0x43E110)

// pxcos
#define DegreeCosine \
    ((float (__cdecl *)(int deg))0x4091C0)

// eNX`}l[W
// CHandleManager<IDirect3DTexture *>
#define g_textureMgr ((void *)0x867A90)
// Direct3DfoCX
// IDirect3DDevice9*
#define g_pd3dDev    (*((IDirect3DDevice9**)0x8689B8))
// _
// CRenderer
#define g_renderer   ((void *)0x85E6EC)
// lbg[NIuWFNg
// CNetworkServer/CNetworkClient
#define g_pnetObject (*(char**)0x860220)
// vt@C
// char *
#define g_pprofP1 ((char*)(g_pnetObject + 0x04))
#define g_pprofP2 ((char*)(g_pnetObject + 0x24))
// UDPlbg[NIuWFNg
// CNetworkBase
#define g_pnetUdp    (g_pnetObject + 0x3BC)
// sA
// vector<SWRClientInfo> ?
#define g_psvClients (g_pnetUdp + 0x10C)
// T[oAhX
// in_addr
#define g_ptoAddr    (g_pnetUdp + 0x3C)
// og}l[W
// CBattleManager *
#define g_pbattleMgr (*(void **)0x860164)
// CtH}l[W
// CInfoManager *
#define g_pinfoMgr   (*(void **)0x860168)
// [h
// int
#define g_commMode   (*(DWORD*)0x860210)
#define g_subMode    (*(DWORD*)0x860208)
#define g_menuMode   (*(DWORD*)0x84AA94)
// V[ID
// DWORD
#define g_sceneIdNew (*(DWORD*)0x867BC8)
#define g_sceneId    (*(DWORD*)0x867BCC)
// Ro[gf[^ptO
// bool
#define g_useCVxData (*(bool*)0x867BD0)
// pbgIuWFNg
// void *
#define g_paletter   (*(void **)0x85E728)
// Cvbg}l[W
// CInputManager ?
#define g_inputMgr   ((void *)0x860298)
// Cvbg}l[WNX^
// CInputManagerCluster
#define g_inputMgrs  ((void *)0x861DC8)
// LN^ID
// int
#define g_leftCharID (*(int*)0x861890)
#define g_rightCharID (*(int*)0x8618B0)
// argc/argv
#define __argc       (*(int*)0x8626D8)
#define __argv       (*(char***)0x8626DC)

// z֐e[u
#define vtbl_CLogo              0x821730
#define vtbl_Opening            0x8217CC
#define vtbl_CLoading           0x82165C
#define vtbl_CTitle             0x821FA4
#define vtbl_CSelect            0x821D1C
#define vtbl_CSelectScenario    0x821DD0
#define vtbl_CBattle            0x821490
#define vtbl_Ending             0x82160C
#define vtbl_CSelectSV          0x8214CC
#define vtbl_CLoadingSV         0x8214EC
#define vtbl_CBattleSV          0x821508
#define vtbl_CSelectCL          0x821524
#define vtbl_CLoadingCL         0x821544
#define vtbl_CBattleCL          0x821560
#define vtbl_CLoadingWatch      0x822178
#define vtbl_CBattleWatch       0x82157C
#define vtbl_CBattleManager     0x8228E4

// NX\z֐caller
#define CLogo_Creater           0x41DB47
#define Opening_Creater         0x41DB81
#define CLoading_Creater        0x41DBBB
#define CTitle_Creater          0x41DBF5
#define CSelect_Creater         0x41DC2F
#define CSelectScenario_Creater 0x41DC69
#define CBattle_Creater         0x41DCA0
#define Ending_Creater          0x41DCDA
#define CSelectSV_Creater       0x41DD14
#define CLoadingSV_Creater      0x41DD4E
#define CBattleSV_Creater       0x41DD85
#define CSelectCL_Creater       0x41DDBF
#define CLoadingCL_Creater      0x41DDF9
#define CBattleCL_Creater       0x41DE30
#define CLoadingWatch_Creater   0x41DE66
#define CBattleWatch_Creater    0x41DE99
#define CBattleManager_Creater  0x439980

// NXTCYIyh

#define CLogo_Size              (*(DWORD*)0x41DB25)
#define Opening_Size            (*(DWORD*)0x41DB5F)
#define CLoading_Size           (*(DWORD*)0x41DB99)
#define CTitle_Size             (*(DWORD*)0x41DBD3)
#define CSelect_Size            (*(DWORD*)0x41DC0D)
#define CSelectScenario_Size    (*(DWORD*)0x41DC47)
#define CBattle_Size            (*(BYTE *)0x41DC81)
#define Ending_Size             (*(DWORD*)0x41DCB8)
#define CSelectSV_Size          (*(DWORD*)0x41DCF2)
#define CLoadingSV_Size         (*(DWORD*)0x41DD2C)
#define CBattleSV_Size          (*(BYTE *)0x41DD66)
#define CSelectCL_Size          (*(DWORD*)0x41DD9D)
#define CLoadingCL_Size         (*(DWORD*)0x41DDD7)
#define CBattleCL_Size          (*(BYTE *)0x41DE11)
#define CLoadingWatch_Size      (*(DWORD*)0x41DE48)
#define CBattleWatch_Size       (*(BYTE *)0x41DE7E)
#define CBattleManager_Size     (*(DWORD*)0x439962)

// ZNVTCY
#define text_Offset  0x401000
#define text_Size    0x420000
#define rdata_Offset 0x821000
#define rdata_Size   0x029000
#define data_Offset  0x84A000
#define data_Size    0x020000

// ---------------- ܂Ńev ----------------
#endif
