#include <config.h>
#include <stdlib.h>

static unsigned char*
buffer_add(unsigned char* buffer, unsigned int* buffer_pos, unsigned int* buffer_size, unsigned char b)
{
	if (*buffer_pos >= *buffer_size) {
		*buffer_size *= 2;
		buffer = realloc(buffer, *buffer_size);
	}
	buffer[(*buffer_pos)++] = b;
	return buffer;
}

unsigned char*
th_rle(const unsigned char* in, unsigned int insize, unsigned int* outsize)
{
	const unsigned char* orig_in = in;
	unsigned char* buffer = NULL;
	unsigned int buffer_size = 1024;
	int prevc = -1;
	int c = -1;
	int rl = 0;

	buffer = malloc(buffer_size);

	while ((in - orig_in) < insize) {
		c = *in++;
		if (rl) {
			if (c != prevc || rl == 0x100) {
				buffer = buffer_add(buffer, outsize, &buffer_size, rl - 1);
				rl = 0;
				buffer = buffer_add(buffer, outsize, &buffer_size, c);
			}
		} else {
			buffer = buffer_add(buffer, outsize, &buffer_size, c);
		}

		if (c == prevc)
			rl++;

		prevc = c;
	}

	if (rl)
		buffer = buffer_add(buffer, outsize, &buffer_size, rl - 1);

	return buffer;
}
