/*
 * Redistribution and use in source and binary forms, with
 * or without modification, are permitted provided that the
 * following conditions are met:
 *
 * 1. Redistributions of source code must retain this list
 *    of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce this
 *    list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the
 *    distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#include <config.h>
#ifdef HAVE_STDINT_H
#include <stdint.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef WIN32
#ifdef HAVE_WINDOWS_H
#include <windows.h>
#else
__declspec(dllimport) int __stdcall MultiByteToWideChar(unsigned int,unsigned int,char*,int,wchar_t*,int);
#endif
#endif

unsigned char*
write_bytes(const unsigned char* bytes, unsigned int length, unsigned char* buffer_ptr)
{
	memcpy(buffer_ptr, bytes, length);
	return buffer_ptr + length;
}

unsigned char*
write_uint16(uint16_t value, unsigned char* buffer_ptr)
{
	memcpy(buffer_ptr, &value, sizeof(uint16_t));
	return buffer_ptr + sizeof(uint16_t);
}

unsigned char*
write_uint32(uint32_t value, unsigned char* buffer_ptr)
{
	memcpy(buffer_ptr, &value, sizeof(uint32_t));
	return buffer_ptr + sizeof(uint32_t);
}

/* Find out file size, might be better to use stat, but it's probably less cross-platform. */
/* This will fail for 2GB+ files, but who cares. */
long
fsize(FILE* stream)
{
	long prev, end;

	prev = ftell(stream);
	if (prev == -1)
		return -1;

	if (fseek(stream, 0, SEEK_END) == -1)
		return -1;

	end = ftell(stream);
	if (end == -1)
		return -1;

	if (fseek(stream, prev, SEEK_SET) == -1)
		return -1;

	return end;
}

#ifdef WIN32

static wchar_t*
mb2wc(char* str)
{
	int length;
	wchar_t* wstr;

	length = MultiByteToWideChar(0, 0, str, -1, NULL, 0);
	if (!length)
		return NULL;

	wstr = malloc(length * sizeof(wchar_t));

	length = MultiByteToWideChar(0, 0, str, -1, wstr, length);
	if (!length)
		return NULL;

	return wstr;
}

FILE*
__cdecl __wrap_fopen(const char *path, const char *mode)
{
	wchar_t* wpath = NULL;
	wchar_t* wmode = NULL;
	FILE* ret = NULL;

	wpath = mb2wc(path);
	wmode = mb2wc(mode);

	if (wpath && wmode)
		ret = _wfopen(wpath, wmode);

	free(wpath);
	free(wmode);

	return ret;
}

#endif
