#include "pch.hpp"
#include "AlwaysRecordable.hpp"
#include "dlgcommon.hpp"
#include "trackrecorddlg.hpp"
#include "trfilterdlg.hpp"
#include "scoreline.hpp"
#include "characters.hpp"
#include "resource.h"

#define MINIMAL_USE_PROCESSHEAPARRAY
#include "MinimalArray.hpp"

#define EVEN_COLOR 0xFFFFFF
#define ODD_COLOR  0xD0DCD0

typedef Minimal::ProcessHeapArrayT<SCORELINE_FILTER> ScoreLineFilterArray;

static struct {
	DWORD fmt;
	int cx;
	LPCSTR text;
} s_listColumns[] = {
	{ LVCFMT_LEFT,  130, "^CX^v" },
	{ LVCFMT_LEFT,  100, "1Pvt" },
	{ LVCFMT_LEFT,  60, "1PL" },
	{ LVCFMT_RIGHT, 40, "1P" },
	{ LVCFMT_LEFT,  100, "2Pvt" },
	{ LVCFMT_LEFT,  60, "2PL" },
	{ LVCFMT_RIGHT, 40, "2P" },
};

static LRESULT TrackrecordView_OnCustomDraw(HWND hwnd, LPNMLVCUSTOMDRAW lpnlvCustomDraw)
{
	switch(lpnlvCustomDraw->nmcd.dwDrawStage) {
	case CDDS_PREPAINT:
		return CDRF_NOTIFYITEMDRAW;
	case CDDS_ITEMPREPAINT:
		if(lpnlvCustomDraw->nmcd.lItemlParam)
			lpnlvCustomDraw->clrTextBk = ODD_COLOR;
		else
			lpnlvCustomDraw->clrTextBk = EVEN_COLOR;
		return CDRF_NOTIFYSUBITEMDRAW;
	default:
		return CDRF_DODEFAULT;
	}
}

static void TrackRecordDialog_QueryCallback(SCORELINE_ITEM *item, void *user)
{
	HWND listWnd = (HWND)user;
	char text[256];

	SYSTEMTIME systime;
	FileTimeToSystemTime((FILETIME *)&item->timestamp, &systime);
	LVITEM lvitem;

	lvitem.mask = LVIF_TEXT | LVIF_PARAM;
	lvitem.iItem = 0;
	lvitem.iSubItem = 0;
	lvitem.lParam = item->p1win > item->p2win;
	lvitem.pszText = text;
	::wsprintf(text, "%d/%02d/%02d %02d:%02d%:%02d",
		systime.wYear, systime.wMonth, systime.wDay,
		systime.wHour, systime.wMinute, systime.wSecond);
	ListView_InsertItem(listWnd, &lvitem);

	lvitem.mask = LVIF_TEXT;
	lvitem.iSubItem = 1;
	lvitem.pszText = item->p1name;
	ListView_SetItem(listWnd, &lvitem);

	lvitem.iSubItem = 2;
	lvitem.pszText = (LPSTR)g_characters[item->p1id].abbr;
	ListView_SetItem(listWnd, &lvitem);

	lvitem.iSubItem = 3;
	lvitem.pszText = text;
	::wsprintf(text, "%d", item->p1win);
	ListView_SetItem(listWnd, &lvitem);

	lvitem.iSubItem = 4;
	lvitem.pszText = item->p2name;
	ListView_SetItem(listWnd, &lvitem);

	lvitem.iSubItem = 5;
	lvitem.pszText = (LPSTR)g_characters[item->p2id].abbr;
	ListView_SetItem(listWnd, &lvitem);

	lvitem.iSubItem = 6;
	lvitem.pszText = text;
	::wsprintf(text, "%d", item->p2win);
	ListView_SetItem(listWnd, &lvitem);
}

static LRESULT TrackRecordDialog_OnNotify(HWND hDlg, int idCtrl, LPNMHDR pNMHdr)
{
	switch(idCtrl) {
	case IDC_LIST_TRACKRECORD:
		switch(pNMHdr->code) {
		case NM_CUSTOMDRAW:
			return TrackrecordView_OnCustomDraw(pNMHdr->hwndFrom, (LPNMLVCUSTOMDRAW)pNMHdr);
		}
		break;
	}
	return FALSE;
}

static BOOL TrackRecordDialog_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
//	if(TrackRecordFilterDialog_ShowModal((HWND)lParam, NULL) != IDOK)
//		return FALSE;

	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_TRACKRECORD);
	ListView_SetExtendedListViewStyle(listWnd, LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);

	LVCOLUMN column;
	column.mask	= LVCF_FMT | LVCF_TEXT | LVCF_WIDTH;
	for(int i = 0; i < ARRAYSIZE(s_listColumns); ++i) {
		column.fmt = s_listColumns[i].fmt;
		column.cx = s_listColumns[i].cx;
		column.cchTextMax = 256;
		column.pszText = (LPSTR)s_listColumns[i].text;
		ListView_InsertColumn(listWnd, i, &column);
	}

	SCORELINE_FILTER_DESC filterDesc;
	filterDesc.mask = 0;
	int limit = 0;

	if(g_trfltP1NameEnabled) {
		filterDesc.mask |= SCORELINE_FILTER__P1NAME;
		::lstrcpy(filterDesc.p1name, g_trfltP1Name);
	}

	if(g_trfltP2NameEnabled) {
		filterDesc.mask |= SCORELINE_FILTER__P2NAME;
		::lstrcpy(filterDesc.p2name, g_trfltP2Name);
	}

	if(g_trfltP1CharEnabled) {
		filterDesc.mask |= SCORELINE_FILTER__P1ID;
		filterDesc.p1id = g_trfltP1Char;
	}

	if(g_trfltP2CharEnabled) {
		filterDesc.mask |= SCORELINE_FILTER__P2ID;
		filterDesc.p2id = g_trfltP2Char;
	}

	if(g_trfltDateBeginEnabled)
	{
		filterDesc.mask |= SCORELINE_FILTER__TIMESTAMP_BEGIN;
		filterDesc.t_begin = g_trfltDateBegin;
	}

	if(g_trfltDateEndEnabled)
	{
		filterDesc.mask |= SCORELINE_FILTER__TIMESTAMP_END;
		filterDesc.t_end = g_trfltDateEnd;

	}

	if(g_trfltLimitEnabled)
	{
		filterDesc.mask |= SCORELINE_FILTER__LIMIT;
		filterDesc.limit = g_trfltLimit;
	}

	ScoreLine_QueryTrackRecordLog(filterDesc, TrackRecordDialog_QueryCallback, listWnd);
	ShowWindow(hDlg, SW_SHOW);
	return TRUE;
}

static void TrackRecordDialog_OnCommand(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
{
	switch(id) {
	case IDOK:
	case IDCANCEL:
		DestroyWindow(hDlg);
		break;
	}
}

static BOOL CALLBACK TrackRecordDialog_DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_DLG_MSG(hDlg, WM_COMMAND, TrackRecordDialog_OnCommand);
	HANDLE_DLG_MSG(hDlg, WM_INITDIALOG, TrackRecordDialog_OnInitDialog);
	HANDLE_DLG_MSG(hDlg, WM_NOTIFY, TrackRecordDialog_OnNotify);
	}
	return FALSE;
}

int TrackRecordDialog_ShowModeless(HWND hwndParent, LPVOID lpUser)
{
	HWND hWnd = ::CreateDialogParamA(
		g_hInstance,
		MAKEINTRESOURCE(IDD_TRACKRECORD),
		hwndParent,
		TrackRecordDialog_DlgProc,
		(LPARAM)hwndParent);
	return hWnd != NULL;
}
