#include "pch.hpp"
#include "dlgcommon.hpp"
#include "rankprofdlg.hpp"
#include "trfilterdlg.hpp"
#include "trackrecorddlg.hpp"
#include "scoreline.hpp"
#include "resource.h"

#define UC_REFLESH 0xEE00

#define EVEN_COLOR 0xFFFFFF
#define ODD_COLOR  0xD0DCD0

static struct {
	DWORD fmt;
	int cx;
	LPCSTR text;
} s_listColumns[] = {
	{ LVCFMT_LEFT,  100, "" },
	{ LVCFMT_RIGHT,  55, "ΐ퐔" },
	{ LVCFMT_RIGHT,  55, "" },
	{ LVCFMT_RIGHT,  55, "" },
	{ LVCFMT_RIGHT,  55, "" },
};

static void RankProfDialog_QueryCallback(SCORELINE_ITEM *item, void *user)
{
	HWND listWnd = (HWND)user;

	char text[256];
	LVITEM lvitem;
	lvitem.mask = LVIF_TEXT;
	lvitem.cchTextMax = sizeof item->p2name;
	lvitem.iItem = 0;
	lvitem.iSubItem = 0;
	lvitem.pszText = item->p2name;
	ListView_InsertItem(listWnd, &lvitem);

	lvitem.iSubItem = 1;
	lvitem.pszText = text;
	lvitem.cchTextMax = sizeof text;
	::wsprintf(text, "%d", item->p1win + item->p2win);
	ListView_SetItem(listWnd, &lvitem);

	lvitem.iSubItem = 2;
	::wsprintf(text, "%d", item->p1win);
	ListView_SetItem(listWnd, &lvitem);

	lvitem.iSubItem = 3;
	::wsprintf(text, "%d", item->p2win);
	ListView_SetItem(listWnd, &lvitem);

	int sum = item->p1win + item->p2win;
	lvitem.iSubItem = 4;
	::wsprintf(text, "%d", ::MulDiv(item->p1win, 100, sum ? sum : 1));
	ListView_SetItem(listWnd, &lvitem);
}

static void SysMenu_OnClose(HWND hDlg, int x, int y)
{
	DestroyWindow(hDlg);
}

static void SysMenu_OnReflesh(HWND hDlg, int x, int y)
{
	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	ListView_DeleteAllItems(listWnd);
	SCORELINE_FILTER_DESC filterDesc;
	filterDesc.mask = 0;
	ScoreLine_QueryProfileRank(filterDesc, RankProfDialog_QueryCallback, (void*)listWnd);
}

static LRESULT ScoreLineView_OnCustomDraw(HWND hwnd, LPNMLVCUSTOMDRAW lpnlvCustomDraw)
{
	switch(lpnlvCustomDraw->nmcd.dwDrawStage) {
	case CDDS_PREPAINT:
		return CDRF_NOTIFYITEMDRAW;
	case CDDS_ITEMPREPAINT:
		if(lpnlvCustomDraw->nmcd.dwItemSpec & 1)
			lpnlvCustomDraw->clrTextBk = EVEN_COLOR;
		else
			lpnlvCustomDraw->clrTextBk = ODD_COLOR;
		return CDRF_NOTIFYSUBITEMDRAW;
	default:
		return CDRF_DODEFAULT;
	}
}

static LRESULT ScoreLineView_OnDoubleClick(HWND hParent, HWND hwnd)
{
	int index = ListView_GetSelectionMark(hwnd);
	if (index >= 0) {
		LVITEM item;
		item.mask = LVIF_TEXT;
		item.iItem = index;
		item.iSubItem = 0;
		item.cchTextMax = sizeof g_trfltP2Name;
		item.pszText = g_trfltP2Name;
		ListView_GetItem(hwnd, &item);

		g_trfltP2NameEnabled = true;

		TrackRecordDialog_ShowModeless(GetParent(hParent), NULL);
	}
	return FALSE;
}

static void RankProfDialog_OnSysCommand(HWND hDlg, UINT nID, int x, int y)
{
	if(nID == SC_CLOSE) {
		SysMenu_OnClose(hDlg, x, y);
	} else if(nID == UC_REFLESH) {
		SysMenu_OnReflesh(hDlg, x, y);
	}
}

static LRESULT RankProfDialog_OnNotify(HWND hDlg, int idCtrl, LPNMHDR pNMHdr)
{
	switch(idCtrl) {
	case IDC_LIST_SCORELINE:
		switch(pNMHdr->code) {
		case NM_CUSTOMDRAW:
			return ScoreLineView_OnCustomDraw(pNMHdr->hwndFrom, (LPNMLVCUSTOMDRAW)pNMHdr);
		case NM_DBLCLK:
			return ScoreLineView_OnDoubleClick(hDlg, pNMHdr->hwndFrom);
		}
		break;
	}
	return FALSE;
}

static BOOL RankProfDialog_InitSysMenu(HWND hDlg)
{
	HMENU hSysMenu = ::GetSystemMenu(hDlg, FALSE);
	int itemIndex = 0;
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_REFLESH, "ŐV̏ɍXV");
	::InsertMenu(hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	return TRUE;
}

static BOOL RankProfDialog_InitListView(HWND hDlg)
{
	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	ListView_SetExtendedListViewStyle(listWnd, LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);

	LVCOLUMN column;
	column.mask	= LVCF_FMT | LVCF_TEXT | LVCF_WIDTH;
	for(int i = 0; i < ARRAYSIZE(s_listColumns); ++i) {
		column.fmt = s_listColumns[i].fmt;
		column.cx = s_listColumns[i].cx;
		column.cchTextMax = 256;
		column.pszText = (LPSTR)s_listColumns[i].text;
		ListView_InsertColumn(listWnd, i, &column);
	}
	SCORELINE_FILTER_DESC filterDesc;
	filterDesc.mask = 0;
	ScoreLine_QueryProfileRank(filterDesc, RankProfDialog_QueryCallback, (void*)listWnd);
	return TRUE;
}

static BOOL RankProfDialog_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
	SetWindowText(hDlg, "vt@C");
	RankProfDialog_InitSysMenu(hDlg);
	RankProfDialog_InitListView(hDlg);
	return TRUE;
}

BOOL CALLBACK RankProfDialog_DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_DLG_MSG(hDlg, WM_INITDIALOG, RankProfDialog_OnInitDialog);
	HANDLE_DLG_MSG(hDlg, WM_SYSCOMMAND, RankProfDialog_OnSysCommand);
	HANDLE_DLG_MSG(hDlg, WM_NOTIFY, RankProfDialog_OnNotify);
	}
	return FALSE;
}
