#pragma once

#include "SWRSAddrDef.h"

enum SCORELINE_FILTER_TYPE
{
	SCORELINE_FILTER_P1NAME,
	SCORELINE_FILTER_P1ID,
	SCORELINE_FILTER_P2NAME,
	SCORELINE_FILTER_P2ID,
	SCORELINE_FILTER_TIMESTAMP_BEGIN,
	SCORELINE_FILTER_TIMESTAMP_END,
};

struct SCORELINE_FILTER
{
	SCORELINE_FILTER_TYPE type;
	union {
		char name[0x10];
		int id;
		int limit;
		time_t timestamp;
	};
};

struct SCORELINE_ITEM
{
	time_t timestamp;
	char p1name[SWRS_ADDR_PROFSIZE + 1];
	int p1id;
	int p1win;
	char p2name[SWRS_ADDR_PROFSIZE + 1];
	int p2id;
	int p2win;
};

bool ScoreLine_Open(bool create);
void ScoreLine_Close();

void ScoreLine_Enter();
void ScoreLine_Leave(bool failed);

bool ScoreLine_QueryTrackRecord(SCORELINE_FILTER *filters, int count);
bool ScoreLine_QueryTrackRecord(SCORELINE_FILTER *filters, int count, int limit);
bool ScoreLine_QueryProfileRank(SCORELINE_FILTER *filters, int count, void(*callback)(SCORELINE_ITEM *, void *), void *user);
bool ScoreLine_QueryTrackRecordLog(SCORELINE_FILTER *filters, int count, int limit, void(*callback)(SCORELINE_ITEM *, void *), void *user);

DWORD ScoreLine_Read(int p1, int p2, int idx);

bool ScoreLine_Append(SCORELINE_ITEM *item);
bool ScoreLine_Remove(time_t timestamp);

void ScoreLine_SetPath(LPCSTR path);
LPCSTR ScoreLine_GetPath();

