#include "pch.hpp"
#include "AlwaysRecordable.hpp"
#include "mainwnd.hpp"
#include "shortcut.hpp"

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalPath.hpp"

// VOg
HINSTANCE g_hInstance;
Minimal::ProcessHeapStringT<char> g_appPath;
CProfileIO g_settings;

static bool Application_PreTranslateMessage(MSG &msg)
{
	return MainWindow_PreTranslateMessage(msg);
}

static LPARAM Application_Run()
{
	MSG msg;
	while(::GetMessage(&msg, NULL, 0, 0) > 0) {
		if(Application_PreTranslateMessage(msg)) {
			::TranslateMessage(&msg);
			::DispatchMessage(&msg);
		}
	}
	return msg.lParam;
}

#ifndef _DEBUG
int main()
{
	g_hInstance = (HINSTANCE)GetModuleHandle(NULL);

	char appPath[1025];
	::GetModuleFileName(GetModuleHandle(NULL), appPath, sizeof appPath);
	::PathRemoveFileSpec(appPath);
	g_appPath = appPath;

	Minimal::ProcessHeapPathA settingPath = g_appPath;
	settingPath /= "tsk.ini";
	g_settings.SetPath(settingPath);

	::InitCommonControls();

	return !MainWindow_Initialize() ? -1
		: Application_Run();
}
#else
int APIENTRY WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
	g_hInstance = (HINSTANCE)GetModuleHandle(NULL);

	char appPath[1025];
	::GetModuleFileName(GetModuleHandle(NULL), appPath, sizeof appPath);
	::PathRemoveFileSpec(appPath);
	g_appPath = appPath;

	Minimal::ProcessHeapPathA settingPath = g_appPath;
	settingPath /= "hikouseki.ini";
	OutputDebugString(settingPath);
	g_settings.SetPath(settingPath);

	return 	
		!MainWindow_Initialize() ? -1
		: Application_Run();
}
#endif
