#include "pch.hpp"
#include "AlwaysRecordable.hpp"
#include "dlgcommon.hpp"
#include "trfilterdlg.hpp"
#include "characters.hpp"
#include "SWRSAddrDef.h"
#include "resource.h"

char   g_trfltP1Name[SWRS_ADDR_PROFSIZE + 1];
char   g_trfltP2Name[SWRS_ADDR_PROFSIZE + 1];
char   g_trfltP1Char;
char   g_trfltP2Char;
time_t g_trfltDateBegin;
time_t g_trfltDateEnd;
int    g_trfltLimit;

bool   g_trfltP1NameEnabled;
bool   g_trfltP2NameEnabled;
bool   g_trfltP1CharEnabled;
bool   g_trfltP2CharEnabled;
bool   g_trfltDateBeginEnabled;
bool   g_trfltDateEndEnabled;
bool   g_trfltLimitEnabled;

static BOOL TrackRecordFilterDialog_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
	HWND p1charCombo = GetDlgItem(hDlg, IDC_COMBO_P1CHAR);
	HWND p2charCombo = GetDlgItem(hDlg, IDC_COMBO_P2CHAR);

	for(int i = 0; i < _countof(g_characters); ++i) {
		ComboBox_AddString(p1charCombo, g_characters[i].full);
		ComboBox_AddString(p2charCombo, g_characters[i].full);
	}
	ComboBox_SetCurSel(p1charCombo, 0);
	ComboBox_SetCurSel(p2charCombo, 0);

	return TRUE;
}

static void TrackRecordFilterDialog_OnCheck(HWND hDlg, int checkId, int targetId)
{
	LRESULT state = 
		::SendDlgItemMessage(hDlg, checkId, BM_GETCHECK, 0, 0);

	::EnableWindow(GetDlgItem(hDlg, targetId), state == BST_CHECKED);
}

static void TrackRecordFilterDialog_OnOK(HWND hDlg)
{
	SYSTEMTIME sysTime;

	g_trfltP1NameEnabled = (::SendDlgItemMessage(hDlg, IDC_CHECK_P1NAME, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_trfltP2NameEnabled = (::SendDlgItemMessage(hDlg, IDC_CHECK_P2NAME, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_trfltP1CharEnabled = (::SendDlgItemMessage(hDlg, IDC_CHECK_P1CHAR, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_trfltP2CharEnabled = (::SendDlgItemMessage(hDlg, IDC_CHECK_P2CHAR, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_trfltDateBeginEnabled = (::SendDlgItemMessage(hDlg, IDC_CHECK_DATEBEG, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_trfltDateEndEnabled   = (::SendDlgItemMessage(hDlg, IDC_CHECK_DATEEND, BM_GETCHECK, 0, 0) == BST_CHECKED);
	g_trfltLimitEnabled = (::SendDlgItemMessage(hDlg, IDC_CHECK_TRMAX, BM_GETCHECK, 0, 0) == BST_CHECKED);


	if(g_trfltP1NameEnabled) {
		::GetDlgItemText(hDlg, IDC_EDIT_P1NAME, g_trfltP1Name, SWRS_ADDR_PROFSIZE);
	}

	if(g_trfltP2NameEnabled) {
		::GetDlgItemText(hDlg, IDC_EDIT_P2NAME, g_trfltP2Name, SWRS_ADDR_PROFSIZE);
	}

	if(g_trfltP1CharEnabled) {
		g_trfltP1Char = ComboBox_GetCurSel(GetDlgItem(hDlg, IDC_COMBO_P1CHAR));
	}

	if(g_trfltP2CharEnabled) {
		g_trfltP2Char = ComboBox_GetCurSel(GetDlgItem(hDlg, IDC_COMBO_P2CHAR));
	}

	if(g_trfltDateBeginEnabled)
	{
		::SendDlgItemMessage(hDlg, IDC_DTP_DATEBEG, DTM_GETSYSTEMTIME, 0, (LPARAM)&sysTime);
		sysTime.wHour =
		sysTime.wMinute =
		sysTime.wSecond =
		sysTime.wMilliseconds = 0;
		::SystemTimeToFileTime(&sysTime, (LPFILETIME)&g_trfltDateBegin);
	}

	if(g_trfltDateEndEnabled)
	{
		::SendDlgItemMessage(hDlg, IDC_DTP_DATEEND, DTM_GETSYSTEMTIME, 0, (LPARAM)&sysTime);
		sysTime.wHour = 23;
		sysTime.wMinute = 59;
		sysTime.wSecond = 59;
		sysTime.wMilliseconds = 999;
		::SystemTimeToFileTime(&sysTime, (LPFILETIME)&g_trfltDateEnd);

		if(g_trfltDateBeginEnabled && g_trfltDateBegin > g_trfltDateEnd) {
			::MessageBox(hDlg, "n_͏I_OɂĂ", NULL, MB_OK | MB_ICONEXCLAMATION);
			return;
		}
	}

	if(g_trfltLimitEnabled)
	{
		g_trfltLimit = SendDlgItemMessage(hDlg, IDC_SPIN_TRMAX, UDM_GETPOS, 0, 0);
		if(g_trfltLimit < 1) {
			::MessageBox(hDlg, "͂PȏɂĂ", NULL, MB_OK | MB_ICONEXCLAMATION);
			return;
		}
	}

	EndDialog(hDlg, IDOK);
}

static void TrackRecordFilterDialog_OnCancel(HWND hDlg)
{
	EndDialog(hDlg, IDCANCEL);
}

static void TrackRecordFilterDialog_OnCommand(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
{
	switch(id) {
	case IDC_CHECK_P1NAME: TrackRecordFilterDialog_OnCheck(hDlg, id, IDC_EDIT_P1NAME); break;
	case IDC_CHECK_P2NAME: TrackRecordFilterDialog_OnCheck(hDlg, id, IDC_EDIT_P2NAME); break;
	case IDC_CHECK_P1CHAR: TrackRecordFilterDialog_OnCheck(hDlg, id, IDC_COMBO_P1CHAR); break;
	case IDC_CHECK_P2CHAR: TrackRecordFilterDialog_OnCheck(hDlg, id, IDC_COMBO_P2CHAR); break;
	case IDC_CHECK_DATEBEG:TrackRecordFilterDialog_OnCheck(hDlg, id, IDC_DTP_DATEBEG); break;
	case IDC_CHECK_DATEEND:TrackRecordFilterDialog_OnCheck(hDlg, id, IDC_DTP_DATEEND); break;
	case IDC_CHECK_TRMAX:  TrackRecordFilterDialog_OnCheck(hDlg, id, IDC_EDIT_TRMAX); break;
	case IDOK:     TrackRecordFilterDialog_OnOK(hDlg); break;
	case IDCANCEL: TrackRecordFilterDialog_OnCancel(hDlg); break;
	}
}

static BOOL CALLBACK TrackRecordFilterDialog_DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_DLG_MSG(hDlg, WM_COMMAND, TrackRecordFilterDialog_OnCommand);
	HANDLE_DLG_MSG(hDlg, WM_INITDIALOG, TrackRecordFilterDialog_OnInitDialog);
	}
	return FALSE;
}

int TrackRecordFilterDialog_ShowModal(HWND hwndParent, LPVOID lpUser)
{
	return ::DialogBoxParamA(
		g_hInstance, MAKEINTRESOURCE(IDD_TRFILTER), hwndParent,
		TrackRecordFilterDialog_DlgProc, (LPARAM)lpUser);
}
