#include "pch.hpp"
#include "scorelinedlg.hpp"
#include "scoreline.hpp"
#include "Formatter.hpp"
#include "characters.hpp"
#include "memento.hpp"
#include "clipboard.hpp"
#include "SWRSAddrDef.h"
#include "resource.h"

#define MINIMAL_USE_PROCESSHEAPSTRING
#include "MinimalPath.hpp"

#define MINIMAL_USE_PROCESSHEAPARRAY
#include "MinimalArray.hpp"

#define EVEN_COLOR 0xFFFFFF
#define ODD_COLOR  0xD0DCD0

#define UC_REFLESH 0xDEAD
#define UC_UNDOSCR 0xBEEF
#define UC_REDOSCR 0xBEAF

#define UC_CLIPBRD 0xFF00

#define PROP_FILTER "arFlt"
#define PROP_P1ID   "arP1ID"

static struct {
	DWORD fmt;
	int cx;
	LPCSTR text;
} s_listColumns[] = {
	{ LVCFMT_LEFT,   80, "O" },
	{ LVCFMT_RIGHT,  55, "ΐ퐔" },
	{ LVCFMT_RIGHT,  55, "" },
	{ LVCFMT_RIGHT,  55, "" },
	{ LVCFMT_RIGHT,  55, "" },
	{ LVCFMT_RIGHT,  55, "ߋ30" },
};

__inline
static void ScoreLineQIBSpecDialog_RefleshUnit(HWND listWnd, int i, int win, int lose)
{
	Minimal::ProcessHeapStringT<char> itemstr;

	LVITEM item;
	item.mask = LVIF_TEXT;
	item.cchTextMax = 256;

	int sum = win + lose;
	// ΐ퐔
	itemstr = Formatter("%d", sum);
	item.iItem = i;
	item.iSubItem = 1;
	item.pszText = (LPSTR)itemstr;
	ListView_SetItem(listWnd, &item);
	// 
	itemstr = Formatter("%d", win);
	item.iSubItem = 2;
	item.pszText = (LPSTR)itemstr;
	ListView_SetItem(listWnd, &item);
	// 
	itemstr = Formatter("%d", lose);
	item.iSubItem = 3;
	item.pszText = (LPSTR)itemstr;
	ListView_SetItem(listWnd, &item);
	// 
	itemstr = 
		Formatter("%d%%", 
			::MulDiv(win, 100, sum ? sum : 1));
	item.iSubItem = 4;
	item.pszText = (LPSTR)itemstr;
	ListView_SetItem(listWnd, &item);
}

static void ScoreLineQIBSpecDialog_Reflesh(HWND hDlg)
{
	ScoreLine_Enter();

	Minimal::ProcessHeapArrayT<SCORELINE_FILTER> *fltCustom 
		= (Minimal::ProcessHeapArrayT<SCORELINE_FILTER> *)
			GetProp(hDlg, PROP_FILTER);
	if(!fltCustom)
		goto exception;

	if(!ScoreLine_QueryTrackRecord(fltCustom->GetRaw(), fltCustom->GetSize()))
		goto exception;

	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);

	int sumWinAll, sumLoseAll;
	sumWinAll = sumLoseAll = 0;
	for(int i = 0; i < SWRSCHAR_MAX; ++i) {
		int sumWin, sumLose;
		sumWin = sumLose = 0;
		for(int j = 0; j < SWRSCHAR_MAX; ++j) {
			sumWin  += ScoreLine_Read(j, i, 0);
			sumLose += ScoreLine_Read(j, i, 1);
		}
		sumWinAll  += sumWin;
		sumLoseAll += sumLose;
		ScoreLineQIBSpecDialog_RefleshUnit(listWnd, i, sumWin, sumLose);
	}

	LVITEM item;
	item.mask = LVIF_TEXT;
	item.cchTextMax = 256;

	// ߋ30폟
	{
		Minimal::ProcessHeapStringT<char> itemstr;
		Minimal::ProcessHeapArrayT<SCORELINE_FILTER> flt_30s(1);

		sumWinAll = sumLoseAll = 0;
		flt_30s += *fltCustom;
		flt_30s[0].type = SCORELINE_FILTER_P2ID;
		for(int i = 0; i < SWRSCHAR_MAX; ++i) {
			flt_30s[0].id = i;
			if(!ScoreLine_QueryTrackRecord(flt_30s.GetRaw(), flt_30s.GetSize(), 30))
				goto exception;

			int sumWin, sumLose, sum;
			sumWin = sumLose = 0;
			for(int j = 0; j < SWRSCHAR_MAX; ++j) {
				sumWin  += ScoreLine_Read(j, i, 0);
				sumLose += ScoreLine_Read(j, i, 1);
			}
			sum = sumWin + sumLose;
			itemstr = 
				Formatter("(%d%%)", 
					::MulDiv(sumWin, 100, sum ? sum : 1));
			item.iItem = i;
			item.iSubItem = 5;
			item.pszText = (LPSTR)itemstr;
			ListView_SetItem(listWnd, &item);
		}
	}

	ScoreLine_Leave(false);
	return;

exception:
	ScoreLine_Leave(true);
	MessageBox(hDlg, "ѕ\̍XVɎs܂", NULL, MB_OK | MB_ICONSTOP);
}

static void SysMenu_OnClose(HWND hDlg, int x, int y)
{
	DestroyWindow(hDlg);
}

static void SysMenu_OnReflesh(HWND hDlg, int x, int y)
{
	ScoreLineQIBSpecDialog_Reflesh(hDlg);
}

static void SysMenu_OnUndo(HWND hDlg, int x, int y)
{
	Memento_Undo();
	ScoreLineQIBSpecDialog_Reflesh(hDlg);
	::PostMessage(GetParent(hDlg), UM_UPDATESCORELINE, 0, 0);
}

static void SysMenu_OnRedo(HWND hDlg, int x, int y)
{
	Memento_Redo();
	ScoreLineQIBSpecDialog_Reflesh(hDlg);
	::PostMessage(GetParent(hDlg), UM_UPDATESCORELINE, 0, 0);
}

static void SysMenu_OnCopyClipboard(HWND hDlg, int x, int y)
{
	Minimal::ProcessHeapStringA result;

	for(int i = 0; i < _countof(s_listColumns); ++i) {
		if(s_listColumns[i].fmt == LVCFMT_LEFT) {
			result += s_listColumns[i].text;
			for(int j = ::lstrlen(s_listColumns[i].text); j < s_listColumns[i].cx / 7; ++j)
				result += " ";
		} else {
			for(int j = ::lstrlen(s_listColumns[i].text); j < s_listColumns[i].cx / 7; ++j)
				result += " ";
			result += s_listColumns[i].text;
		}
	}
	result += "\x0D\x0A";

	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	int count = ListView_GetItemCount(listWnd);

	for(int i = 0; i < count; ++i) {
		for(int j = 0; j < _countof(s_listColumns); ++j) {
			TCHAR text[64];
			ListView_GetItemText(listWnd, i, j, text, _countof(text));
			if(s_listColumns[j].fmt == LVCFMT_LEFT) {
				result += text;
				for(int k = ::lstrlen(text); k < s_listColumns[j].cx / 7; ++k)
					result += " ";
			} else {
				for(int k = ::lstrlen(text); k < s_listColumns[j].cx / 7; ++k)
					result += " ";
				result += text;
			}
		}
		result += "\x0D\x0A";
	}
	SetClipboardText(result, result.GetSize());
}

static LRESULT ScoreLineView_OnCustomDraw(HWND hwnd, LPNMLVCUSTOMDRAW lpnlvCustomDraw)
{
	switch(lpnlvCustomDraw->nmcd.dwDrawStage) {
	case CDDS_PREPAINT:
		return CDRF_NOTIFYITEMDRAW;
	case CDDS_ITEMPREPAINT:
		if(lpnlvCustomDraw->nmcd.dwItemSpec & 1)
			lpnlvCustomDraw->clrTextBk = EVEN_COLOR;
		else
			lpnlvCustomDraw->clrTextBk = ODD_COLOR;
		return CDRF_NOTIFYSUBITEMDRAW;
	default:
		return CDRF_DODEFAULT;
	}
}

static LRESULT ScoreLineView_OnDoubleClick_Common(HWND hParent, HWND hwnd, int score)
{
	LVHITTESTINFO hti;

	hti.flags = LVHT_ONITEMLABEL;
	GetCursorPos(&hti.pt);
	ScreenToClient(hwnd, &hti.pt);
	// qbg
	if(ListView_SubItemHitTest(hwnd, &hti) != -1) {
		// 
		if(hti.iSubItem == 2 || hti.iSubItem == 3) {
			SCORELINE_ITEM item;

			SYSTEMTIME loctime;
			GetLocalTime(&loctime);
			SystemTimeToFileTime(&loctime, (LPFILETIME)&item.timestamp);

			item.p1name[0] = 0;
			item.p1id = (int)::GetProp(hParent, PROP_P1ID);
			item.p1win = hti.iSubItem == 2 ? score : 0;
			item.p2name[0] = 0;
			item.p2id = hti.iItem;
			item.p2win = hti.iSubItem == 3 ? score : 0;

			ScoreLine_Enter();
			bool failed = !ScoreLine_Append(&item);
			ScoreLine_Leave(failed);
			if(!failed) {
				Memento_Append(&item);

				ScoreLineQIBSpecDialog_Reflesh(hParent);
				::PostMessage(GetParent(hParent), UM_UPDATESCORELINE, 0, 0);
			}
		}
	}
	return TRUE;
}

static LRESULT ScoreLineView_OnDoubleClick(HWND hParent, HWND hwnd)
{
	return ScoreLineView_OnDoubleClick_Common(hParent, hwnd, 2);
}

static LRESULT ScoreLineView_OnRDoubleClick(HWND hParent, HWND hwnd)
{
	return ScoreLineView_OnDoubleClick_Common(hParent, hwnd, -2);
}

static BOOL ScoreLineQIBSpecDialog_InitListView(HWND hDlg)
{
	HWND listWnd = GetDlgItem(hDlg, IDC_LIST_SCORELINE);
	ListView_SetExtendedListViewStyle(listWnd, LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);

	LVCOLUMN column;
	column.mask	= LVCF_FMT | LVCF_TEXT | LVCF_WIDTH;
	for(int i = 0; i < ARRAYSIZE(s_listColumns); ++i) {
		column.fmt = s_listColumns[i].fmt;
		column.cx = s_listColumns[i].cx;
		column.cchTextMax = 256;
		column.pszText = (LPSTR)s_listColumns[i].text;
		ListView_InsertColumn(listWnd, i, &column);
	}

	LVITEM item;
	item.mask = LVIF_TEXT;
	item.cchTextMax = 256;
	item.iSubItem = 0;
	for(int i = 0; i < ARRAYSIZE(g_characters); ++i) {
		item.pszText = (LPSTR)g_characters[i].abbr;
		item.iItem = i;
		ListView_InsertItem(listWnd, &item);
	}

	return TRUE;
}

static void ScoreLineQIBSpecDialog_InitCaption(HWND hDlg, Minimal::ProcessHeapArrayT<SCORELINE_FILTER> *fltCustom)
{
	Minimal::ProcessHeapStringT<char> title;

	title = "ڍ - ";
	SYSTEMTIME loctime;
	for(size_t i = 0; i < fltCustom->GetSize(); ++i) {
		switch((*fltCustom)[i].type) {
			case SCORELINE_FILTER_P1ID:
				title += 
					Formatter("1P(%s) ", 
						g_characters[(*fltCustom)[i].id].abbr);
				break;
			case SCORELINE_FILTER_P2NAME:
				title += 
					Formatter("2P[%s] ", (*fltCustom)[i].name);
				break;
			case SCORELINE_FILTER_TIMESTAMP_BEGIN:
				FileTimeToSystemTime(
					(LPFILETIME)&(*fltCustom)[i].timestamp, &loctime);
				title += 
					Formatter("%d/%02d/%02d", 
						loctime.wYear, loctime.wMonth, loctime.wDay);
				break;
			case SCORELINE_FILTER_TIMESTAMP_END:
				FileTimeToSystemTime(
					(LPFILETIME)&(*fltCustom)[i].timestamp, &loctime);
				title += 
					Formatter("%d/%02d/%02d܂", 
						loctime.wYear, loctime.wMonth, loctime.wDay);
				break;
		}
	}
	::SetWindowText(hDlg, title);
}

static void ScoreLineQIBSpecDialog_InitSysMenu(HWND hDlg, HMENU hSysMenu)
{
	int itemIndex = 0;
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_REFLESH, "ŐV̏ɍXV");
	::InsertMenu(hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_UNDOSCR, "ɖ߂");
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_REDOSCR, "蒼");
	::InsertMenu(hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
	::InsertMenu(hSysMenu, itemIndex++, MF_STRING | MF_BYPOSITION, UC_CLIPBRD, "Nbv{[hɑ");
	::InsertMenu(hSysMenu, itemIndex++, MF_SEPARATOR | MF_BYPOSITION, 0, NULL);
}


static BOOL ScoreLineQIBSpecDialog_OnInitDialog(HWND hDlg, HWND hwndFocus, LPARAM lParam)
{
	Minimal::ProcessHeapArrayT<SCORELINE_FILTER> *fltCustom 
		= (Minimal::ProcessHeapArrayT<SCORELINE_FILTER> *)lParam;

	for(size_t i = 0; i < fltCustom->GetSize(); ++i)
		if((*fltCustom)[i].type == SCORELINE_FILTER_P1ID) {
			::SetProp(hDlg, PROP_P1ID, (HANDLE)(*fltCustom)[i].id);
			break;
		}
	SetProp(hDlg, PROP_FILTER, (HANDLE)lParam);

	HMENU hSysMenu = ::GetSystemMenu(hDlg, FALSE);
	if(hSysMenu == NULL) return FALSE;


	ScoreLineQIBSpecDialog_InitCaption(hDlg, fltCustom);
	ScoreLineQIBSpecDialog_InitSysMenu(hDlg, hSysMenu);
	ScoreLineQIBSpecDialog_InitListView(hDlg);
	ScoreLineQIBSpecDialog_Reflesh(hDlg);
	return TRUE;
}


static void ScoreLineQIBSpecDialog_OnCommand(HWND hDlg, int id, HWND hwndCtl, UINT codeNotify)
{
}

static void ScoreLineQIBSpecDialog_OnSysCommand(HWND hDlg, UINT nID, int x, int y)
{
	if(nID == SC_CLOSE) {
		SysMenu_OnClose(hDlg, x, y);
	} else if(nID == UC_REFLESH) {
		SysMenu_OnReflesh(hDlg, x, y);
	} else if(nID == UC_UNDOSCR) {
		SysMenu_OnUndo(hDlg, x, y);
	} else if(nID == UC_REDOSCR) {
		SysMenu_OnRedo(hDlg, x, y);
	} else if(nID == UC_CLIPBRD) {
		SysMenu_OnCopyClipboard(hDlg, x, y);
	}
}

static LRESULT ScoreLineQIBSpecDialog_OnNotify(HWND hDlg, int idCtrl, LPNMHDR pNMHdr)
{
	switch(idCtrl) {
	case IDC_LIST_SCORELINE:
		switch(pNMHdr->code) {
		case NM_CUSTOMDRAW:
			return ScoreLineView_OnCustomDraw(pNMHdr->hwndFrom, (LPNMLVCUSTOMDRAW)pNMHdr);
		case NM_DBLCLK:
			return ScoreLineView_OnDoubleClick(hDlg, pNMHdr->hwndFrom);
		case NM_RDBLCLK:
			return ScoreLineView_OnRDoubleClick(hDlg, pNMHdr->hwndFrom);

		}
		break;
	}
	return FALSE;
}

static void ScoreLineQIBSpecDialog_OnDestroy(HWND hDlg)
{
	delete (Minimal::ProcessHeapArrayT<SCORELINE_FILTER> *)GetProp(hDlg, PROP_FILTER);
	RemoveProp(hDlg, PROP_FILTER);
}

static void ScoreLineQIBSpecDialog_OnNCRButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT codeHitTest)
{
	if(codeHitTest == HTCAPTION) {
		HMENU hSysMenu = GetSystemMenu(hwnd, FALSE);
		EnableMenuItem(hSysMenu, UC_UNDOSCR, Memento_Undoable() ? MF_ENABLED : MF_GRAYED);
		EnableMenuItem(hSysMenu, UC_REDOSCR, Memento_Redoable() ? MF_ENABLED : MF_GRAYED);
	}
}

BOOL CALLBACK ScoreLineQIBSpecDialog_DlgProc(HWND hDlg, UINT Msg, WPARAM wParam, LPARAM lParam)
{
	switch(Msg) {
	HANDLE_DLG_MSG(hDlg, WM_INITDIALOG, ScoreLineQIBSpecDialog_OnInitDialog);
	HANDLE_DLG_MSG(hDlg, WM_DESTROY, ScoreLineQIBSpecDialog_OnDestroy);
	HANDLE_DLG_MSG(hDlg, WM_COMMAND, ScoreLineQIBSpecDialog_OnCommand);
	HANDLE_DLG_MSG(hDlg, WM_SYSCOMMAND, ScoreLineQIBSpecDialog_OnSysCommand);
	HANDLE_DLG_MSG(hDlg, WM_NCRBUTTONDOWN, ScoreLineQIBSpecDialog_OnNCRButtonDown);
	HANDLE_DLG_MSG(hDlg, WM_NOTIFY, ScoreLineQIBSpecDialog_OnNotify);
	}
	return FALSE;
}
