#include <stdio.h>
#include <stdlib.h>

#define BGM_FILE1 "thbgm.fmt"
#define BGM_FILE2 "thbgm_tr.fmt"
#define SIZE_MAX 1000000
#define KEY_SIZE 4

static char key[ KEY_SIZE ] = { ".wav" };

int main( int argc, char *argv[] )
{
  FILE *fp1, *fp2;
  unsigned char data[ SIZE_MAX ];
  size_t agree, number, size, skip;
  size_t i, j, k;

  if( argc > 1 && strcmp( argv[ 1 ], "-tr" ) == 0 ) fp1 = fopen( BGM_FILE2, "rb" );
  else fp1 = fopen( BGM_FILE1, "rb" );
  if( fp1 == NULL )
  {
    if( argc > 1 && strcmp( argv[ 1 ], "-tr" ) == 0 ) fprintf( stderr, "%sJ܂\n", BGM_FILE2 );
    else fprintf( stderr, "%sJ܂\n", BGM_FILE1 );

    exit( EXIT_FAILURE );
  }

  fp2 = fopen( "table.txt", "w" );
  number = 1;
  size = fread( data, sizeof( unsigned char ), SIZE_MAX, fp1 );
  for( i = 0; i < size - 12; i++ )
  {
    agree = 0;
    for( j = 0; j < KEY_SIZE; j++ )
    {
      if( data[ i + j ] == key[ j ] ) agree++;
    }
    if( agree == KEY_SIZE )
    {
      skip = 0;
      while( data[ i + KEY_SIZE + skip ] == '\0' ) skip++;
      if( number > 1 ) fprintf( fp2, ",\n" );
      fprintf( fp2, "\t{0x" );
      for( k = 4; k >= 1; k-- ) fprintf( fp2, "%02X", data[ i + j + k + skip - 1 ] );
      fprintf( fp2, ", 0x" );
      for( k = 12; k >= 9; k-- ) fprintf( fp2, "%02X", data[ i + j + k + skip - 1 ] );
      fprintf( fp2, ", 0x" );
      for( k = 16; k >= 13; k-- ) fprintf( fp2, "%02X", data[ i + j + k + skip - 1 ] );
      fprintf( fp2, "}" );
      number++;
    }
  }
  fprintf( fp2, "\n" );
  fprintf( stdout, "I܂\n" );

  fclose( fp1 );
  fclose( fp2 );

  return EXIT_SUCCESS;
}
