#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


#define BGM_FILE	"thbgm.dat"
#define MAX_BGM		21

int bgmtable[MAX_BGM][3]={
	{0x00000010, 0x000F1AC0, 0x00C20500},
	{0x00C20510, 0x000AAE00, 0x0160EB00},
	{0x0222F010, 0x002A8000, 0x00D20000},
	{0x02F4F010, 0x00076F00, 0x0192D000},
	{0x0487C010, 0x0044D680, 0x01031100},
	{0x058AD110, 0x0029D200, 0x00F88000},
	{0x06835110, 0x0048A600, 0x01342A00},
	{0x07B77B10, 0x00164B00, 0x01008000},
	{0x08B7FB10, 0x0023AB00, 0x01B98000},
	{0x0A717B10, 0x001BAC00, 0x01552000},
	{0x0BC69B10, 0x0011FB00, 0x01D5A900},
	{0x0D9C4410, 0x00082680, 0x01437E00},
	{0x0EDFC210, 0x00196AC0, 0x00E8B4A0},
	{0x0FC876B0, 0x0012DB00, 0x01DF8400},
	{0x11A7FAB0, 0x00BCA380, 0x00DC7C00},
	{0x128476B0, 0x0065E700, 0x01E47000},
	{0x1468E6B0, 0x002F1A00, 0x00F18200},
	{0x155A68B0, 0x00346980, 0x011BD500},
	{0x16763DB0, 0x000D7280, 0x01AB7C80},
	{0x1821BA30, 0x00145E20, 0x01DBD790},
	{0x19FD91C0, 0x0010DC00, 0x00D44A80}
};

char bgmfile[MAX_BGM][50]={
	"01 i鏴@` Eastern Night..wav",
	"02 ̖@` Ghostly Eyes.wav",
	"03 忁XH@` Mooned Insect.wav",
	"04 鐝̉̐@` Night Bird.wav",
	"05 ̂Ȃ.wav",
	"06 ̌@` Old World.wav",
	"07 vCGCWA.wav",
	"08 i̕񂢁@` Imperishable Night..wav",
	"09 Yzȁ@` Dream Battle.wav",
	"10 F}X^[Xp[N.wav",
	"11 VfP[W@` Kagome-Kagome.wav",
	"12 C̓@` Invisible Full Moon.wav",
	"13 H[W1969.wav",
	"14 Nz@` History of the Moon.wav",
	"15 |ā@` Lunatic Princess.wav",
	"16 H[W1970.wav",
	"17 GNXehAbV@` Hl.wav",
	"18 ܂œ͂As̉.wav",
	"19 .wav",
	"20 Eternal Dream@` H̞.wav",
	"21 d.wav"
};

void makeheader(char *header,int datasize){
	int i;
	short s;
	memcpy(header,"RIFF",4);
	i = datasize + 36;
	memcpy(header+4,&i,4);
	memcpy(header+8,"WAVEfmt ",8);
	i = 16;
	memcpy(header+16,&i,4);
	s = 1;
	memcpy(header+20,&s,2);
	s = 2;
	memcpy(header+22,&s,2);
	i = 44100;
	memcpy(header+24,&i,4);
	i = 176400;
	memcpy(header+28,&i,4);
	s = 4;
	memcpy(header+32,&s,2);
	s = 16;
	memcpy(header+34,&s,2);
	memcpy(header+36,"data",4);
	i = datasize;
	memcpy(header+40,&i,4);

}

int main(int argc,char *argv[]){
	FILE *datf,*bgmf;
	int i,j,l,k;
	int rep=2;
	int length;
	int fade=0;
	int fadep=0;
	int ts=0;
	int te=MAX_BGM;
	char header[44];
	short buf[44100*2];
	int s,e;
	double d;


	//bgmtable(JnAJԂn_܂ł̒AI_܂ł̒)Ȃ̂
	//ꂼʒuɊZ
	for(i=0;i<MAX_BGM;i++){
		bgmtable[i][1]+=bgmtable[i][0];
		bgmtable[i][2]+=bgmtable[i][0];
	}

	//argc̃`FbN
	for(i=1;i<argc;i++){
		switch(argv[i][0]){
		case 'f' :
			argv[i]++; fade=atoi(argv[i]); break;
		case 'F' :
			argv[i]++; fade=-atoi(argv[i]); break;
		case 'P' :
		case 'p' :
			argv[i]++; fadep=atoi(argv[i]); break;
		case 'T' :
		case 't' :
			argv[i]++; ts=te=atoi(argv[i]); break;
		default:
			rep=atoi(argv[i]);
		}
	}

	if(rep<1 || rep>10){
		printf("repeat must be 1-10\n");
		return 0;
	}
	if(fade<-30 || fade>30){
		printf("fade must be 0-30\n");
		return 0;
	}
	if(fadep<0 || fadep>3){
		printf("fade pattern must be 0-3\n");
		return 0;
	}
	if(ts<0 || te>MAX_BGM){
		printf("track number must be 1-%d\n", MAX_BGM);
		return 0;
	}


	printf("track=%d-%d , repeat=%d , fade=%d , fade pattern=%d\n",ts+1,te,rep,fade,fadep);
	if(ts) ts--;

	datf=fopen(BGM_FILE,"rb");
	if(datf==NULL){
		printf("%s not found.", BGM_FILE);
		return 0;
	}

	//Jn
	for(i=ts;i<te;i++){

		printf("Create %s ...\n",bgmfile[i]);
		bgmf=fopen(bgmfile[i],"wb");
		length=(bgmtable[i][2]-bgmtable[i][0])+(bgmtable[i][2]-bgmtable[i][1])*(rep-1);
		if(fade<0) length+=(-fade)*44100*4;
		makeheader(header,length);
		fwrite(header,1,44,bgmf);

		//[v
		for(k=0;k<rep;k++){
			//[
			s=bgmtable[i][1];
			if(k==0) s=bgmtable[i][0];

			//I[
			e=bgmtable[i][2];
			if(k==rep-1 && fade>0) e=bgmtable[i][2]-fade*44100*4;

			for(j=s;j<e;j+=44100*4){
				if(j+44100*4>e) l=e-j;
				else l=44100*4;

				fseek(datf,j,SEEK_SET);
				fread(buf,1,l,datf);
				fwrite(buf,1,l,bgmf);
			}
		}

		//tF[hAEg
		if(fade>0){
			//[vI[
			s=bgmtable[i][2]-fade*44100*4;
			e=bgmtable[i][2];
		}
		else if(fade<0){
			//[v[
			s=bgmtable[i][1];
			e=s-fade*44100*4;
		}
		else{
			s=e=0;
		}

		for(j=s;j<e;j+=44100*4){
			if(j+44100*4>e) l=e-j;
			else l=44100*4;

			fseek(datf,j,SEEK_SET);
			fread(buf,1,l,datf);
			for(k=0;k<l/4;k++){
				switch (fadep) {
				case 0 :
					d=(float)((j-s)/4+k)/(abs(fade)*44100);
					d=pow(0.001,d);
					break;
				case 1 :
					d=1-(float)((j-s)/4+k)/(abs(fade)*44100);
					break;
				case 2 :
					d=(float)((j-s)/4+k)/(abs(fade)*44100);
					d=(pow(0.001,d)+(1-d))/2;
					break;
				case 3 :
					d=(cos(3.1415926535*(float)((j-s)/4+k)/(abs(fade)*44100))+1)/2;
					break;
				}

				buf[2*k]=(short)(buf[2*k]*d);
				buf[2*k+1]=(short)(buf[2*k+1]*d);
			}
			fwrite(buf,1,l,bgmf);
		}

		fclose(bgmf);
	}
	fclose(datf);

	return 0;
}
